/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Interval;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.generation.statement.lazy.LazyStatementGeneratorDescription;
import org.eclipse.wb.internal.core.model.variable.description.LazyVariableDescription;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.AbstractGridBagConstraintsInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagConstraintsInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingTestUtils;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class GridBagLayoutTest
extends AbstractGridBagLayoutTest {
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setToDefault("GridBagLayout.changeInsets.forGaps");
        preferences.setToDefault("GridBagLayout.gap.column");
        preferences.setToDefault("GridBagLayout.gap.row");
        super.tearDown();
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_fieldAssignment() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"button\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 2;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        GridBagConstraintsInfo gbc = GridBagLayoutInfo.getConstraintsFor((ComponentInfo)button);
        GridBagLayoutTest.assertRelatedNodes((JavaInfo)gbc, new String[]{"new GridBagConstraints()", "gbc.gridx = 1", "gbc.gridy = 2", "add(button, gbc)"});
        GridBagLayoutTest.assertVisible((ObjectInfo)gbc, false);
        GridBagConstraints gbcObject = gbc.getGridBagConstraints();
        GridBagLayoutTest.assertEquals((int)1, (int)gbcObject.gridx);
        GridBagLayoutTest.assertEquals((int)2, (int)gbcObject.gridy);
    }

    @Test
    public void test_extraParentChild() throws Exception {
        GridBagLayoutTest.setFileContentSrc("test/AFrame.java", this.getTestSource("public class AFrame extends JFrame {\n\tprotected void addGB(Container parent, Component child, int x, int y) {\n\t\tGridBagConstraints constraints = new GridBagConstraints();\n\t\tconstraints.gridx = x;\n\t\tconstraints.gridy = y;\n\t\tparent.add(child, constraints);\n\t}\n}"));
        GridBagLayoutTest.setFileContentSrc("test/AFrame.wbp-component.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<component xmlns=\"http://www.eclipse.org/wb/WBPComponent\">\n\t<methods>\n\t\t<method name=\"addGB\">\n\t\t\t<parameter type=\"java.awt.Container\" parent2=\"true\"/>\n\t\t\t<parameter type=\"java.awt.Component\" child2=\"true\"/>\n\t\t\t<parameter type=\"int\"/>\n\t\t\t<parameter type=\"int\"/>\n\t\t</method>\n\t</methods>\n</component>");
        GridBagLayoutTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("public class Test extends AFrame {\n\tpublic Test() {\n\t\tgetContentPane().setLayout(new GridBagLayout());\n\t\taddGB(getContentPane(), new JButton(\"1 x 1\"), 1, 1);\n\t\taddGB(getContentPane(), new JButton(\"2 x 2\"), 2, 2);\n\t}\n}");
        frame.refresh();
        GridBagLayoutTest.assertNoErrors((JavaInfo)frame);
        ContainerInfo contentPane = (ContainerInfo)frame.getChildrenComponents().get(0);
        GridBagLayout gblObject = (GridBagLayout)contentPane.getContainer().getLayout();
        GridBagLayoutTest.assertEquals((int)2, (int)contentPane.getChildrenComponents().size());
        Container container = contentPane.getContainer();
        Component[] components = container.getComponents();
        GridBagLayoutTest.assertEquals((int)2, (int)components.length);
        ComponentInfo button = (ComponentInfo)contentPane.getChildrenComponents().get(0);
        GridBagConstraints gbcObject = gblObject.getConstraints(button.getComponent());
        GridBagLayoutTest.assertEquals((int)1, (int)gbcObject.gridx);
        GridBagLayoutTest.assertEquals((int)1, (int)gbcObject.gridy);
        button = (ComponentInfo)contentPane.getChildrenComponents().get(1);
        gbcObject = gblObject.getConstraints(button.getComponent());
        GridBagLayoutTest.assertEquals((int)2, (int)gbcObject.gridx);
        GridBagLayoutTest.assertEquals((int)2, (int)gbcObject.gridy);
    }

    @Test
    public void test_ComboBox_andBaseline() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.rowWeights = new double[]{1.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJComboBox combo = new JComboBox();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.anchor = GridBagConstraints.BASELINE;\n\t\t\tadd(combo, gbc);\n\t\t}\n\t}\n}");
        this.refresh();
        GridBagLayoutTest.assertNoErrors((JavaInfo)panel);
    }

    @Test
    public void test_keepSize() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetSize(600, 250);\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t}\n}");
        this.refresh();
        GridBagLayoutTest.assertEquals((Object)new Dimension(600, 250), (Object)panel.getBounds().getSize());
    }

    @Test
    public void test_grid() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\tlayout.columnWidths = new int[]{0, 0, 0, 0};\n\t\tlayout.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowHeights = new int[]{0, 0, 0, 0};\n\t\tlayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tadd(button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,\n\t\t\t\t\tGridBagConstraints.CENTER, GridBagConstraints.BOTH,\n\t\t\t\t\tnew Insets(0, 0, 5, 5), 0, 0));\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 0 2 1\");\n\t\t\tadd(button, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0,\n\t\t\t\t\tGridBagConstraints.CENTER, GridBagConstraints.BOTH,\n\t\t\t\t\tnew Insets(0, 0, 5, 5), 0, 0));\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 1\");\n\t\t\tadd(button, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,\n\t\t\t\t\tGridBagConstraints.CENTER, GridBagConstraints.BOTH,\n\t\t\t\t\tnew Insets(0, 0, 5, 5), 0, 0));\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 2\");\n\t\t\tadd(button, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0,\n\t\t\t\t\tGridBagConstraints.CENTER, GridBagConstraints.BOTH,\n\t\t\t\t\tnew Insets(0, 0, 5, 15), 0, 0));\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 2 2\");\n\t\t\tadd(button, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0,\n\t\t\t\t\tGridBagConstraints.CENTER, GridBagConstraints.BOTH,\n\t\t\t\t\tnew Insets(0, 0, 5, 5), 0, 0));\n\t\t}\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        List childrenComponents = panel.getChildrenComponents();
        ComponentInfo[] components = childrenComponents.toArray(new ComponentInfo[childrenComponents.size()]);
        GridBagLayoutTest.assertEquals((int)5, (int)components.length);
        panel.refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((int)3, (int)gridInfo.getColumnCount());
        GridBagLayoutTest.assertEquals((int)3, (int)gridInfo.getRowCount());
        Interval[] intervals = gridInfo.getColumnIntervals();
        GridBagLayoutTest.assertEquals((int)3, (int)intervals.length);
        GridBagLayoutTest.assertTrue((intervals[0].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertTrue((intervals[1].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertTrue((intervals[2].length() > 20 ? 1 : 0) != 0);
        intervals = gridInfo.getRowIntervals();
        GridBagLayoutTest.assertEquals((int)3, (int)intervals.length);
        GridBagLayoutTest.assertTrue((intervals[0].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertTrue((intervals[1].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertTrue((intervals[2].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[0]));
        GridBagLayoutTest.assertEquals((Object)new Rectangle(1, 0, 2, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[1]));
        GridBagLayoutTest.assertEquals((Object)new Rectangle(1, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[2]));
        GridBagLayoutTest.assertEquals((Object)new Rectangle(1, 2, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[3]));
        GridBagLayoutTest.assertEquals((Object)new Rectangle(2, 2, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)components[4]));
        gridInfo.getCellsRectangle(new Rectangle(0, 0, 1, 1));
        GridBagLayoutTest.assertEquals((Object)new Insets(0, 0, 0, 0), (Object)gridInfo.getInsets());
        GridBagLayoutTest.assertEquals((int)25, (int)gridInfo.getVirtualColumnSize());
        GridBagLayoutTest.assertEquals((int)5, (int)gridInfo.getVirtualColumnGap());
        GridBagLayoutTest.assertEquals((int)25, (int)gridInfo.getVirtualRowSize());
        GridBagLayoutTest.assertEquals((int)5, (int)gridInfo.getVirtualRowGap());
        GridBagLayoutTest.assertSame((Object)components[0], (Object)gridInfo.getOccupied(0, 0));
        GridBagLayoutTest.assertSame((Object)components[1], (Object)gridInfo.getOccupied(1, 0));
        GridBagLayoutTest.assertSame((Object)components[1], (Object)gridInfo.getOccupied(2, 0));
        GridBagLayoutTest.assertNull((Object)gridInfo.getOccupied(0, 1));
        GridBagLayoutTest.assertSame((Object)components[2], (Object)gridInfo.getOccupied(1, 1));
    }

    @Test
    public void test_grid_noComponents() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t}\n}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        panel.refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((int)0, (int)gridInfo.getColumnCount());
        GridBagLayoutTest.assertEquals((int)0, (int)gridInfo.getRowCount());
    }

    @Test
    public void test_grid_spannedColumn_includeFiller() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[]{0, 0};\n\t\tlayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints constraints = new GridBagConstraints();\n\t\t\tconstraints.gridx = 0;\n\t\t\tconstraints.gridwidth = 2;\n\t\t\tadd(button, constraints);\n\t\t}\n\t}\n}");
        this.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)GridBagLayoutTest.getJavaInfoByName("button");
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((int)2, (int)gridInfo.getColumnCount());
        Rectangle cells = gridInfo.getComponentCells((IAbstractComponentInfo)button);
        Rectangle cellsRectangle = gridInfo.getCellsRectangle(cells);
        GridBagLayoutTest.assertEquals((Object)new Rectangle(0, 0, 2, 1), (Object)cells);
        GridBagLayoutTest.assertEquals((int)cellsRectangle.x, (int)0);
        Assertions.assertThat((int)cellsRectangle.width).isGreaterThan(400);
    }

    @Test
    public void test_grid_spannedRow_includeFiller() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.rowHeights = new int[]{0, 0};\n\t\tlayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints constraints = new GridBagConstraints();\n\t\t\tconstraints.gridy = 0;\n\t\t\tconstraints.gridheight = 2;\n\t\t\tadd(button, constraints);\n\t\t}\n\t}\n}");
        this.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)GridBagLayoutTest.getJavaInfoByName("button");
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((int)2, (int)gridInfo.getRowCount());
        Rectangle cells = gridInfo.getComponentCells((IAbstractComponentInfo)button);
        Rectangle cellsRectangle = gridInfo.getCellsRectangle(cells);
        GridBagLayoutTest.assertEquals((Object)new Rectangle(0, 0, 1, 2), (Object)cells);
        GridBagLayoutTest.assertEquals((int)cellsRectangle.y, (int)0);
        Assertions.assertThat((int)cellsRectangle.height).isGreaterThan(250);
    }

    @Test
    public void test_grid_emptyColumn() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        this.check_grid_emptyColumn(panel);
    }

    @Test
    public void test_grid_emptyColumn_JFrame() throws Exception {
        ContainerInfo frame = this.parseContainer("class Test extends JFrame {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tgetContentPane().setLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tgetContentPane().add(button, gbc);\n\t\t}\n\t}\n}");
        ContainerInfo panel = (ContainerInfo)frame.getChildrenComponents().get(0);
        this.check_grid_emptyColumn(panel);
    }

    @Test
    public void test_grid_emptyColumn2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[]{};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        this.check_grid_emptyColumn(panel);
    }

    @Test
    public void test_grid_emptyColumn3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[]{0, 0, 0};\n\t\tlayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        this.check_grid_emptyColumn(panel);
    }

    @Test
    public void test_grid_emptyColumn_spanned() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0 2 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridwidth = 2;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        this.check_grid_emptyColumn(panel);
    }

    private void check_grid_emptyColumn(ContainerInfo panel) throws Exception {
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        panel.getRoot().refresh();
        IGridInfo gridInfo = layout.getGridInfo();
        Interval[] intervals = gridInfo.getColumnIntervals();
        GridBagLayoutTest.assertEquals((int)2, (int)intervals.length);
        GridBagLayoutTest.assertTrue((intervals[1].length() > 50 ? 1 : 0) != 0);
        GridBagLayoutTest.assertEquals((int)gridInfo.getVirtualColumnSize(), (int)intervals[0].length());
        GridBagLayoutTest.assertEquals((int)gridInfo.getVirtualColumnGap(), (int)(intervals[1].begin() - intervals[0].end()));
    }

    @Test
    public void test_grid_emptyColumn4() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[]{150};\n\t\tlayout.columnWeights = new double[]{0.0};\n\t\tsetLayout(layout);\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        Interval[] intervals = gridInfo.getColumnIntervals();
        GridBagLayoutTest.assertEquals((int)1, (int)intervals.length);
        GridBagLayoutTest.assertEquals((int)145, (int)intervals[0].length());
    }

    @Test
    public void test_grid_emptyRow() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        this.check_grid_emptyRow(panel);
    }

    @Test
    public void test_grid_emptyRow_spanned() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.gridheight = 2;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        this.check_grid_emptyRow(panel);
    }

    private void check_grid_emptyRow(ContainerInfo panel) throws Exception {
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        Interval[] intervals = gridInfo.getRowIntervals();
        GridBagLayoutTest.assertEquals((int)2, (int)intervals.length);
        GridBagLayoutTest.assertTrue((intervals[1].length() > 20 ? 1 : 0) != 0);
        GridBagLayoutTest.assertEquals((int)gridInfo.getVirtualRowSize(), (int)intervals[0].length());
        GridBagLayoutTest.assertEquals((int)gridInfo.getVirtualRowGap(), (int)(intervals[1].begin() - intervals[0].end()));
    }

    @Test
    public void test_grid_lessWeightThanDimensions() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[]{200};\n\t\tlayout.columnWeights = new double[]{0.0};\n\t\tlayout.rowHeights = new int[]{30};\n\t\tlayout.rowWeights = new double[]{0.0};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        Object[] intervals = gridInfo.getColumnIntervals();
        Assertions.assertThat((Object[])intervals).hasSize(2);
        intervals = gridInfo.getRowIntervals();
        Assertions.assertThat((Object[])intervals).hasSize(2);
    }

    @Test
    public void test_grid_emptyRow_whenPack() throws Exception {
        GridBagLayoutTest.setFileContentSrc("test/MyFrame.java", this.getTestSource("public class MyFrame extends JFrame {\n\tprotected void finishInit() {\n\t\tpack();\n\t}\n}"));
        GridBagLayoutTest.setFileContentSrc("test/MyFrame.wbp-component.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<component xmlns=\"http://www.eclipse.org/wb/WBPComponent\">\n\t<methods>\n\t\t<method name=\"finishInit\"/>\n\t</methods>\n\t<parameters>\n\t\t<parameter name=\"topBounds.pack\">true</parameter>\n\t</parameters>\n</component>");
        GridBagLayoutTest.waitForAutoBuild();
        ContainerInfo frame = this.parseContainer("class Test extends MyFrame {\n\tpublic Test() {\n\t\tsetUndecorated(true);\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tgetContentPane().setLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tgetContentPane().add(button, gbc);\n\t\t}\n\t\tfinishInit();\n\t}\n}");
        this.refresh();
        ComponentInfo button = (ComponentInfo)GridBagLayoutTest.getJavaInfoByName("button");
        Rectangle frameBounds = frame.getAbsoluteBounds();
        Rectangle buttonBounds = button.getAbsoluteBounds();
        GridBagLayoutTest.assertTrue((boolean)frameBounds.contains(buttonBounds), (String)(String.valueOf(frameBounds) + " doesn't fully contain " + String.valueOf(buttonBounds)));
    }

    @Test
    public void test_replaceGBL() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(layout)/ /add(button, gbc)/}\n\t{new: java.awt.GridBagLayout} {local-unique: layout} {/new GridBagLayout()/ /setLayout(layout)/}\n\t{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button, gbc)/}\n\t\t{new: java.awt.GridBagConstraints} {local-unique: gbc} {/new GridBagConstraints()/ /gbc.gridx = 1/ /gbc.gridy = 1/ /add(button, gbc)/}");
        panel.refresh();
        LayoutInfo flowLayout = (LayoutInfo)GridBagLayoutTest.createJavaInfo("java.awt.FlowLayout");
        panel.setLayout(flowLayout);
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/ /setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5))/}\n\t{new: java.awt.FlowLayout} {empty} {/setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5))/}\n\t{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
    }

    @Test
    public void test_replaceGBL_whenVirtualConstraints() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(layout)/ /add(button)/}\n\t{new: java.awt.GridBagLayout} {local-unique: layout} {/new GridBagLayout()/ /setLayout(layout)/}\n\t{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}\n\t\t{virtual-GBL-constraints} {virtual-GBL-constraints} {}");
        panel.refresh();
        LayoutInfo flowLayout = (LayoutInfo)GridBagLayoutTest.createJavaInfo("java.awt.FlowLayout");
        panel.setLayout(flowLayout);
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(button)/ /setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5))/}\n\t{new: java.awt.FlowLayout} {empty} {/setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5))/}\n\t{new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}");
    }

    @Test
    public void test_setLayout() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}");
        GridBagLayoutInfo gbl = (GridBagLayoutInfo)GridBagLayoutTest.createJavaInfo("java.awt.GridBagLayout");
        panel.setLayout((LayoutInfo)gbl);
        this.assertEditor("// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\tgridBagLayout.columnWidths = new int[]{0};\n\t\tgridBagLayout.rowHeights = new int[]{0};\n\t\tgridBagLayout.columnWeights = new double[]{Double.MIN_VALUE};\n\t\tgridBagLayout.rowWeights = new double[]{Double.MIN_VALUE};\n\t\tsetLayout(gridBagLayout);\n\t}\n}");
    }

    @Test
    public void test_CREATE_empty_0() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t}\n}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_empty_1() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0};\n\t\tlayout.rowHeights = new int[] {0};\n\t\tlayout.columnWeights = new double[] {Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t}\n}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_empty_2() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0};\n\t\tlayout.rowHeights = new int[] {0};\n\t\tlayout.columnWeights = new double[] {Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t}\n}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 2, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_insertColumn_insertRow() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, true, 0, true);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendColumn_appendRow() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendColumn() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_insertColumn_appendRow_expandSpanColumn() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0 2 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.gridwidth = 2;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, true, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0 2 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.gridwidth = 3;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendColumn_insertRow_expandSpanRow() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0 1 2\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.gridheight = 2;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, false, 1, true);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0 1 2\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.gridheight = 3;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendColumn_differentGap() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setValue("GridBagLayout.gap.column", 10);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 1, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 10);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendRow_differentGap() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setValue("GridBagLayout.gap.row", 10);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 10, 0);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_appendRow_dontChangeInsets_soNoGap() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setValue("GridBagLayout.changeInsets.forGaps", false);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_last_hasEmptyCell() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE_last(button);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_last_noEmptyCell() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE_last(button);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_tooLittleElements_rowHeight() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.rowHeights = new int[] {};\n\t\tlayout.rowWeights = new double[] {};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"existing\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button = GridBagLayoutTest.createJButton();
                layout.command_CREATE(button, 0, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.rowWeights = new double[] {0.0, 0.0};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"existing\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_0() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_00 = (ComponentInfo)panel.getChildrenComponents().get(0);
                layout.command_MOVE(button_00, 1, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 0\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_1() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_11 = (ComponentInfo)panel.getChildrenComponents().get(1);
                layout.command_MOVE(button_11, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button 1 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"button 0 1\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0};\n\t\tlayout.rowWeights = new double[] {0.0, 1.0};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJPanel innerPanel = new JPanel();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(innerPanel, gbc);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"button\");\n\t\t\t\tinnerPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        panel.refresh();
        final GridBagLayoutInfo gridLayout = (GridBagLayoutInfo)panel.getLayout();
        ContainerInfo innerPanel = (ContainerInfo)panel.getChildrenComponents().get(0);
        final FlowLayoutInfo flowLayout = (FlowLayoutInfo)innerPanel.getLayout();
        final ComponentInfo button = (ComponentInfo)innerPanel.getChildrenComponents().get(0);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                gridLayout.command_MOVE(button, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0};\n\t\tlayout.rowWeights = new double[] {0.0, 1.0};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJPanel innerPanel = new JPanel();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(innerPanel, gbc);\n\t\t}\n\t}\n}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                flowLayout.move(button, null);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0};\n\t\tlayout.rowWeights = new double[] {0.0, 1.0};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJPanel innerPanel = new JPanel();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(innerPanel, gbc);\n\t\t\t{\n\t\t\t\tJButton button = new JButton(\"button\");\n\t\t\t\tinnerPanel.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                gridLayout.command_MOVE(button, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0};\n\t\tlayout.rowWeights = new double[] {0.0, 1.0};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton(\"button\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t\t{\n\t\t\tJPanel innerPanel = new JPanel();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(innerPanel, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_4() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"button 1\");\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"button 2\");\n\t\t\tadd(button_2);\n\t\t}\n\t\t{\n\t\t\tJButton button_3 = new JButton(\"button 3\");\n\t\t\tadd(button_3);\n\t\t}\n\t}\n}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(2);
                layout.command_MOVE(button_2, 2, false, 1, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"button 1\");\n\t\t\tadd(button_1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 5, 5), 0, 0));\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"button 2\");\n\t\t\tadd(button_2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 5, 5), 0, 0));\n\t\t}\n\t\t{\n\t\t\tJButton button_3 = new JButton(\"button 3\");\n\t\t\tadd(button_3, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 0), 0, 0));\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_MOVE_5() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"button 1\");\n\t\t\tadd(button_1);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"button 2\");\n\t\t\tadd(button_2);\n\t\t}\n\t\t{\n\t\t\tJButton button_3 = new JButton(\"button 3\");\n\t\t\tadd(button_3);\n\t\t}\n\t}\n}");
        panel.refresh();
        Activator.getDefault().getPreferenceStore().setValue("GridBagLayout.longConstraints", true);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(2);
                layout.command_MOVE(button_2, 0, false, 0, true);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button_3 = new JButton(\"button 3\");\n\t\t\tadd(button_3, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 5, 5), 0, 0));\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"button 1\");\n\t\t\tadd(button_1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton(\"button 2\");\n\t\t\tadd(button_2, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(0, 0, 0, 5), 0, 0));\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_DELETE_1() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getRows().size());
        ((ComponentInfo)panel.getChildrenComponents().get(0)).delete();
        GridBagLayoutTest.assertEquals((int)0, (int)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((int)0, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t}\n}");
    }

    @Test
    public void test_DELETE_2() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0};\n\t\tlayout.rowHeights = new int[] {0};\n\t\tlayout.columnWeights = new double[] {0.0};\n\t\tlayout.rowWeights = new double[] {0.0};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getRows().size());
        ((ComponentInfo)panel.getChildrenComponents().get(0)).delete();
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0};\n\t\tlayout.rowHeights = new int[] {0};\n\t\tlayout.columnWeights = new double[] {0.0};\n\t\tlayout.rowWeights = new double[] {0.0};\n\t\tsetLayout(layout);\n\t}\n}");
    }

    @Test
    public void test_DELETE_3() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWeights = new double[] {1.0};\n\t\tlayout.rowWeights = new double[] {1.0};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getRows().size());
        ((ComponentInfo)panel.getChildrenComponents().get(0)).delete();
        GridBagLayoutTest.assertEquals((int)0, (int)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((int)0, (int)layout.getRows().size());
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWeights = new double[] {};\n\t\tlayout.rowWeights = new double[] {};\n\t\tsetLayout(layout);\n\t}\n}");
    }

    @Test
    public void test_setCells_0() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
                layout.command_setCells(button_0, new Rectangle(0, 0, 2, 1));
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridwidth = 2;\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_setCells_1() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 5);\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        final GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        GridBagLayoutTest.assertEquals((int)2, (int)layout.getColumns().size());
        GridBagLayoutTest.assertEquals((int)2, (int)layout.getRows().size());
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ComponentInfo button_0 = (ComponentInfo)panel.getChildrenComponents().get(0);
                layout.command_setCells(button_0, new Rectangle(0, 1, 1, 1));
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tgbc.insets = new Insets(0, 0, 5, 0);\n\t\t\tadd(button_1, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_0 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 1;\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tadd(button_0, gbc);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button_2, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_clipboard() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\tGridBagLayout layout = new GridBagLayout();\n\t\t\tlayout.columnWidths = new int[]{10, 20, 0};\n\t\t\tlayout.columnWeights = new double[]{1.0, 2.0, Double.MIN_VALUE};\n\t\t\tlayout.rowHeights = new int[]{10, 20, 30, 0};\n\t\t\tlayout.rowWeights = new double[]{1.0, 2.0, 3.0, Double.MIN_VALUE};\n\t\t\tinner.setLayout(layout);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.gridx = 1;\n\t\t\t\tgbc.gridy = 2;\n\t\t\t\tinner.add(button, gbc);\n\t\t\t}\n\t\t}\n\t}\n}");
        panel.refresh();
        ContainerInfo inner = (ContainerInfo)GridBagLayoutTest.getJavaInfoByName("inner");
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ContainerInfo newInner = (ContainerInfo)memento.create((JavaInfo)panel);
        ((FlowLayoutInfo)panel.getLayout()).add((ComponentInfo)newInner, null);
        memento.apply();
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\tGridBagLayout layout = new GridBagLayout();\n\t\t\tlayout.columnWidths = new int[]{10, 20, 0};\n\t\t\tlayout.columnWeights = new double[]{1.0, 2.0, Double.MIN_VALUE};\n\t\t\tlayout.rowHeights = new int[]{10, 20, 30, 0};\n\t\t\tlayout.rowWeights = new double[]{1.0, 2.0, 3.0, Double.MIN_VALUE};\n\t\t\tinner.setLayout(layout);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.gridx = 1;\n\t\t\t\tgbc.gridy = 2;\n\t\t\t\tinner.add(button, gbc);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\tGridBagLayout layout = new GridBagLayout();\n\t\t\tlayout.columnWidths = new int[]{10, 20, 0};\n\t\t\tlayout.rowHeights = new int[]{10, 20, 30, 0};\n\t\t\tlayout.columnWeights = new double[]{1.0, 2.0, Double.MIN_VALUE};\n\t\t\tlayout.rowWeights = new double[]{1.0, 2.0, 3.0, Double.MIN_VALUE};\n\t\t\tinner.setLayout(layout);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.gridx = 1;\n\t\t\t\tgbc.gridy = 2;\n\t\t\t\tinner.add(button, gbc);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Disabled
    @Test
    public void test_clipboard_disableAutoAlignment() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\tinner.setLayout(new GridBagLayout());\n\t\t\t{\n\t\t\t\tJLabel label = new JLabel();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.gridx = 0;\n\t\t\t\tgbc.gridy = 0;\n\t\t\t\tinner.add(label, gbc);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJTextField textField = new JTextField();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.gridx = 1;\n\t\t\t\tgbc.gridy = 0;\n\t\t\t\tinner.add(textField, gbc);\n\t\t\t}\n\t\t}\n\t}\n}");
        panel.refresh();
        ContainerInfo inner = (ContainerInfo)GridBagLayoutTest.getJavaInfoByName("inner");
        JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)inner);
        ContainerInfo newInner = (ContainerInfo)memento.create((JavaInfo)panel);
        ((FlowLayoutInfo)panel.getLayout()).add((ComponentInfo)newInner, null);
        memento.apply();
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner);\n\t\t\tinner.setLayout(new GridBagLayout());\n\t\t\t{\n\t\t\t\tJLabel label = new JLabel();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.gridx = 0;\n\t\t\t\tgbc.gridy = 0;\n\t\t\t\tinner.add(label, gbc);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJTextField textField = new JTextField();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.gridx = 1;\n\t\t\t\tgbc.gridy = 0;\n\t\t\t\tinner.add(textField, gbc);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tadd(panel);\n\t\t\tGridBagLayout gridBagLayout = new GridBagLayout();\n\t\t\tgridBagLayout.columnWidths = new int[]{0, 0, 0};\n\t\t\tgridBagLayout.rowHeights = new int[]{0, 0};\n\t\t\tgridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};\n\t\t\tgridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\t\tpanel.setLayout(gridBagLayout);\n\t\t\t{\n\t\t\t\tJLabel label = new JLabel();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\t\tgbc.gridx = 0;\n\t\t\t\tgbc.gridy = 0;\n\t\t\t\tpanel.add(label, gbc);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJTextField textField = new JTextField();\n\t\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\t\tgbc.gridx = 1;\n\t\t\t\tgbc.gridy = 0;\n\t\t\t\tpanel.add(textField, gbc);\n\t\t\t}\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_autoRename_lazyVariable() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                SwingTestUtils.setGenerations(LazyVariableDescription.INSTANCE, LazyStatementGeneratorDescription.INSTANCE);
                SwingTestUtils.setLazyMethodModifier(0);
                try {
                    ComponentInfo button_1 = GridBagLayoutTest.createJButton();
                    layout.command_CREATE(button_1, 0, false, 0, false);
                    GridBagLayoutTest.this.assertEditor("class Test extends JPanel {\n\tprivate JButton button;\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\tgbc.gridx = 0;\n\t\tgbc.gridy = 0;\n\t\tadd(getButton(), gbc);\n\t}\n\tprivate JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton();\n\t\t}\n\t\treturn button;\n\t}\n}");
                    GridBagLayoutTest.setText_withAlwaysRename((JavaInfo)button_1, "aaa");
                    GridBagLayoutTest.this.assertEditor("class Test extends JPanel {\n\tprivate JButton aaaButton;\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\tgbc.gridx = 0;\n\t\tgbc.gridy = 0;\n\t\tadd(getAaaButton(), gbc);\n\t}\n\tprivate JButton getAaaButton() {\n\t\tif (aaaButton == null) {\n\t\t\taaaButton = new JButton();\n\t\t\taaaButton.setText(\"aaa\");\n\t\t}\n\t\treturn aaaButton;\n\t}\n}");
                    ComponentInfo button_2 = GridBagLayoutTest.createJButton();
                    layout.command_CREATE(button_2, 1, false, 0, false);
                    GridBagLayoutTest.this.assertEditor("class Test extends JPanel {\n\tprivate JButton aaaButton;\n\tprivate JButton button;\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\tgbc.gridx = 0;\n\t\tgbc.gridy = 0;\n\t\tadd(getAaaButton(), gbc);\n\t\tGridBagConstraints gbc_1 = new GridBagConstraints();\n\t\tgbc_1.gridx = 1;\n\t\tgbc_1.gridy = 0;\n\t\tadd(getButton(), gbc_1);\n\t}\n\tprivate JButton getAaaButton() {\n\t\tif (aaaButton == null) {\n\t\t\taaaButton = new JButton();\n\t\t\taaaButton.setText(\"aaa\");\n\t\t}\n\t\treturn aaaButton;\n\t}\n\tprivate JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton();\n\t\t}\n\t\treturn button;\n\t}\n}");
                }
                finally {
                    SwingTestUtils.setGenerationDefaults();
                }
            }
        });
    }

    @Test
    public void test_useJPanelWithGBL() throws Exception {
        GridBagLayoutTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {\n\tpublic MyPanel() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\tlayout.columnWidths = new int[]{0, 0};\n\t\tlayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tlayout.rowHeights = new int[]{0, 0};\n\t\tlayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}"));
        GridBagLayoutTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new MyPanel());\n\t}\n}");
        panel.refresh();
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new BorderLayout())/ /add(new MyPanel())/}\n\t{new: java.awt.BorderLayout} {empty} {/setLayout(new BorderLayout())/}\n\t{new: test.MyPanel} {empty} {/add(new MyPanel())/}\n\t\t{implicit-layout: java.awt.GridBagLayout} {implicit-layout} {}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        GridBagLayoutInfo layout = (GridBagLayoutInfo)inner.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((int)1, (int)gridInfo.getColumnCount());
        GridBagLayoutTest.assertEquals((int)1, (int)layout.getColumns().size());
    }

    @Test
    public void test_danglingGBL() throws Exception {
        this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout danglingLayout = new GridBagLayout();\n\t}\n}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}\n\t{implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
    }

    @Test
    public void test_componentInFiller() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tsetLayout(layout);\n\t\tlayout.columnWidths = new int[]{0, 0};\n\t\tlayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\tlayout.rowHeights = new int[]{0, 0};\n\t\tlayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 1;\n\t\t\tadd(button, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        IGridInfo gridInfo = layout.getGridInfo();
        GridBagLayoutTest.assertEquals((int)2, (int)gridInfo.getColumnCount());
        GridBagLayoutTest.assertEquals((int)2, (int)gridInfo.getRowCount());
        Assertions.assertThat((List)layout.getColumns()).hasSize(2);
        Assertions.assertThat((List)layout.getRows()).hasSize(2);
    }

    @Test
    public void test_setLayout_whenContainerOnGBL() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tprivate JPanel inner;\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\tgbc.gridx = 0;\n\t\tgbc.gridy = 0;\n\t\tadd(getInner(), gbc);\n\t}\n\tprivate JPanel getInner() {\n\t\tif (inner == null) {\n\t\t\tinner = new JPanel();\n\t\t}\n\t\treturn inner;\n\t}\n}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new GridBagLayout())/ /add(getInner(), gbc)/}\n\t{new: java.awt.GridBagLayout} {empty} {/setLayout(new GridBagLayout())/}\n\t{new: javax.swing.JPanel} {lazy: inner getInner()} {/new JPanel()/ /inner/ /add(getInner(), gbc)/}\n\t\t{implicit-layout: java.awt.FlowLayout} {implicit-layout} {}\n\t\t{new: java.awt.GridBagConstraints} {local-unique: gbc} {/new GridBagConstraints()/ /gbc.gridx = 0/ /gbc.gridy = 0/ /add(getInner(), gbc)/}");
        panel.refresh();
        ContainerInfo inner = (ContainerInfo)GridBagLayoutTest.getJavaInfoByName("inner");
        LayoutInfo newLayout = (LayoutInfo)GridBagLayoutTest.createJavaInfo("java.awt.GridLayout");
        inner.setLayout(newLayout);
        this.assertEditor("class Test extends JPanel {\n\tprivate JPanel inner;\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\tgbc.gridx = 0;\n\t\tgbc.gridy = 0;\n\t\tadd(getInner(), gbc);\n\t}\n\tprivate JPanel getInner() {\n\t\tif (inner == null) {\n\t\t\tinner = new JPanel();\n\t\t\tinner.setLayout(new GridLayout(1, 0, 0, 0));\n\t\t}\n\t\treturn inner;\n\t}\n}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new GridBagLayout())/ /add(getInner(), gbc)/}\n\t{new: java.awt.GridBagLayout} {empty} {/setLayout(new GridBagLayout())/}\n\t{new: javax.swing.JPanel} {lazy: inner getInner()} {/new JPanel()/ /inner/ /add(getInner(), gbc)/ /inner.setLayout(new GridLayout(1, 0, 0, 0))/}\n\t\t{new: java.awt.GridBagConstraints} {local-unique: gbc} {/new GridBagConstraints()/ /gbc.gridx = 0/ /gbc.gridy = 0/ /add(getInner(), gbc)/}\n\t\t{new: java.awt.GridLayout} {empty} {/inner.setLayout(new GridLayout(1, 0, 0, 0))/}");
    }

    @Test
    public void test_JPopupMenu() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"button\");\n\t\t\tadd(button, new GridBagConstraints());\n\t\t}\n\t\t{\n\t\t\tJPopupMenu popupMenu = new JPopupMenu();\n\t\t\taddPopup(this, popupMenu);\n\t\t}\n\t}\n\tprivate static void addPopup(Component component, JPopupMenu popup) {\n\t}\n}");
        GridBagLayoutTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/setLayout(new GridBagLayout())/ /add(button, new GridBagConstraints())/ /addPopup(this, popupMenu)/}\n\t{new: java.awt.GridBagLayout} {empty} {/setLayout(new GridBagLayout())/}\n\t{new: javax.swing.JButton} {local-unique: button} {/new JButton(\"button\")/ /add(button, new GridBagConstraints())/}\n\t\t{new: java.awt.GridBagConstraints} {empty} {/add(button, new GridBagConstraints())/}\n\t{new: javax.swing.JPopupMenu} {local-unique: popupMenu} {/new JPopupMenu()/ /addPopup(this, popupMenu)/}");
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ComponentInfo button = (ComponentInfo)GridBagLayoutTest.getJavaInfoByName("button");
        Assertions.assertThat((List)layout.getComponents()).containsExactly((Object[])new ComponentInfo[]{button});
    }

    @Test
    public void test_relativeRemainder() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new GridBagLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"Button1\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button2\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button3\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button4\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button5\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button6\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.RELATIVE; // next-to-last in row\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button7\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button8\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = 1;\n\t\t\tc.gridheight = 2;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button9\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tc.gridheight = 1;\n\t\t\tadd(button, c);\n\t\t}\n\t\t{\n\t\t\tJButton button = new JButton(\"Button10\");\n\t\t\tGridBagConstraints c = new GridBagConstraints();\n\t\t\tc.fill = GridBagConstraints.BOTH;\n\t\t\tc.gridwidth = GridBagConstraints.REMAINDER; // end row\n\t\t\tc.gridheight = 1;\n\t\t\tadd(button, c);\n\t\t}\n\t}\n}");
        panel.refresh();
        List buttons = panel.getChildren(ContainerInfo.class);
        GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
        ContainerInfo button = (ContainerInfo)buttons.get(0);
        AbstractGridBagConstraintsInfo constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button1\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)0);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)0);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
        button = (ContainerInfo)buttons.get(1);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button2\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)0);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
        button = (ContainerInfo)buttons.get(2);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button3\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)2);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)0);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
        button = (ContainerInfo)buttons.get(3);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button4\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)3);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)0);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
        button = (ContainerInfo)buttons.get(4);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button5\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)0);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)4);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
        button = (ContainerInfo)buttons.get(5);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button6\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)0);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)2);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)3);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
        button = (ContainerInfo)buttons.get(6);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button7\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)3);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)2);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
        button = (ContainerInfo)buttons.get(7);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button8\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)0);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)3);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)2);
        button = (ContainerInfo)buttons.get(8);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button9\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)3);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)3);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
        button = (ContainerInfo)buttons.get(9);
        constraints = layout.getConstraints((ComponentInfo)button);
        GridBagLayoutTest.assertEquals((Object)ObjectInfo.getText((ObjectInfo)button), (Object)"button - \"Button10\"");
        GridBagLayoutTest.assertEquals((int)constraints.x, (int)1);
        GridBagLayoutTest.assertEquals((int)constraints.y, (int)4);
        GridBagLayoutTest.assertEquals((int)constraints.width, (int)3);
        GridBagLayoutTest.assertEquals((int)constraints.height, (int)1);
    }
}

