/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.jface;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.IField;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.model.jface.FieldEditorLabelsConstantsPropertyEditor;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FieldEditorLabelsConstantsPropertyEditorTest
extends SwingModelTest {
    private final String m_propertyName = "labelsAndValues";
    private Property m_property;
    private FieldEditorLabelsConstantsPropertyEditor m_propertyEditor;
    private List<String> m_resultLabels = new ArrayList<String>();
    private List<IField> m_resultFields = new ArrayList<IField>();

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        FieldEditorLabelsConstantsPropertyEditorTest.setFileContentSrc("test/PrefConstants.java", this.getTestSource("public interface PrefConstants {", "  String ID_1 = 'id 1';", "  String ID_2 = 'id 2';", "}"));
        FieldEditorLabelsConstantsPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public MyPanel() {", "  }", "  public void setLabelsAndValues(String [][] labelsAndValues) {", "  }", "}"));
        FieldEditorLabelsConstantsPropertyEditorTest.setFileContentSrc("test/MyPanel.wbp-component.xml", FieldEditorLabelsConstantsPropertyEditorTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <property id='setLabelsAndValues(java.lang.String[][])'>", "    <editor id='FieldEditor_LabelsConstants'/>", "  </property>", "</component>"));
        FieldEditorLabelsConstantsPropertyEditorTest.waitForAutoBuild();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        this.m_property = null;
        this.m_propertyEditor = null;
        this.m_resultLabels = null;
        this.m_resultFields = null;
    }

    private void prepareProperty() throws Exception {
        this.m_property = this.m_lastParseInfo.getPropertyByTitle("labelsAndValues");
        this.m_propertyEditor = (FieldEditorLabelsConstantsPropertyEditor)this.m_property.getEditor();
    }

    private String getTextForEditing() throws Exception {
        this.prepareProperty();
        String text = (String)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"getTextForEditing", GenericProperty.class, (Object)this.m_property);
        return text.replace(Text.DELIMITER, "\n");
    }

    private String prepareLabelsFields(String text) throws Exception {
        this.prepareProperty();
        return (String)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"prepareLabelsFields", List.class, List.class, GenericProperty.class, String.class, this.m_resultLabels, this.m_resultFields, (Object)this.m_property, (Object)text);
    }

    private String setLabelsFields() throws Exception {
        this.prepareProperty();
        return (String)ReflectionUtils.invokeMethod2((Object)this.m_propertyEditor, (String)"setLabelsFields", List.class, List.class, GenericProperty.class, this.m_resultLabels, this.m_resultFields, (Object)this.m_property);
    }

    @Test
    public void test_getTextForEditing_0() throws Exception {
        this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        FieldEditorLabelsConstantsPropertyEditorTest.assertEquals((Object)"", (Object)this.getTextForEditing());
    }

    @Test
    public void test_getTextForEditing_1() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setLabelsAndValues(new String[][]{{'1', PrefConstants.ID_1}, new String[]{'2', PrefConstants.ID_2}});", "  }", "}");
        FieldEditorLabelsConstantsPropertyEditorTest.assertEquals((Object)FieldEditorLabelsConstantsPropertyEditorTest.getSourceDQ("1 test.PrefConstants.ID_1", "2 test.PrefConstants.ID_2"), (Object)this.getTextForEditing());
    }

    @Test
    public void test_getTextForEditing_2() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public Test() {", "    setLabelsAndValues(new String[][]{{'1', PrefConstants.ID_1}, new String[]{'2', 'Ignored literal'}});", "  }", "}");
        FieldEditorLabelsConstantsPropertyEditorTest.assertEquals((Object)"1 test.PrefConstants.ID_1\n", (Object)this.getTextForEditing());
    }

    @Test
    public void test_prepareLabelsFields() throws Exception {
        this.parseContainer("public class Test extends MyPanel {", "  public static final String LOCAL_ID = 'value';", "  public Test() {", "  }", "}");
        String errorMessage = this.prepareLabelsFields("");
        FieldEditorLabelsConstantsPropertyEditorTest.assertNull((Object)errorMessage);
        Assertions.assertThat(this.m_resultLabels).isEmpty();
        Assertions.assertThat(this.m_resultFields).isEmpty();
        errorMessage = this.prepareLabelsFields("one_word");
        ((AbstractStringAssert)Assertions.assertThat((String)errorMessage).contains(new CharSequence[]{"label"})).contains(new CharSequence[]{"field"});
        errorMessage = this.prepareLabelsFields("label no.such.field");
        Assertions.assertThat((String)errorMessage).contains(new CharSequence[]{"Invalid field"});
        errorMessage = this.prepareLabelsFields(FieldEditorLabelsConstantsPropertyEditorTest.getSourceDQ("some label LOCAL_ID"));
        FieldEditorLabelsConstantsPropertyEditorTest.assertNull((Object)errorMessage);
        Assertions.assertThat(this.m_resultLabels).containsOnly((Object[])new String[]{"some label"});
        Assertions.assertThat(this.m_resultFields).hasSize(1);
        FieldEditorLabelsConstantsPropertyEditorTest.assertEquals((Object)"LOCAL_ID", (Object)this.m_resultFields.get(0).getElementName());
        errorMessage = this.prepareLabelsFields(FieldEditorLabelsConstantsPropertyEditorTest.getSourceDQ("first label test.PrefConstants.ID_1", "second label test.PrefConstants.ID_2"));
        FieldEditorLabelsConstantsPropertyEditorTest.assertNull((Object)errorMessage);
        Assertions.assertThat(this.m_resultLabels).containsOnly((Object[])new String[]{"first label", "second label"});
        Assertions.assertThat(this.m_resultFields).hasSize(2);
        FieldEditorLabelsConstantsPropertyEditorTest.assertEquals((Object)"ID_1", (Object)this.m_resultFields.get(0).getElementName());
        FieldEditorLabelsConstantsPropertyEditorTest.assertEquals((Object)"ID_2", (Object)this.m_resultFields.get(1).getElementName());
        this.setLabelsFields();
        this.assertEditor("public class Test extends MyPanel {", "  public static final String LOCAL_ID = 'value';", "  public Test() {", "    setLabelsAndValues(new String[][]{{'first label', PrefConstants.ID_1}, {'second label', PrefConstants.ID_2}});", "  }", "}");
    }
}

