/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.List;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.requests.ICreationFactory;
import org.eclipse.wb.gef.core.tools.CreationTool;
import org.eclipse.wb.internal.core.editor.palette.model.entry.InstanceFactoryEntryInfo;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.Test;

public class InstanceFactoryEntryInfoTest
extends AbstractPaletteTest {
    @Test
    public void test_access() throws Exception {
        InstanceFactoryEntryInfo entry = new InstanceFactoryEntryInfo();
        InstanceFactoryEntryInfoTest.assertNull((Object)entry.getFactoryClassName());
        entry.setFactoryClassName("test.InstanceFactory");
        InstanceFactoryEntryInfoTest.assertEquals((Object)"test.InstanceFactory", (Object)entry.getFactoryClassName());
        InstanceFactoryEntryInfoTest.assertNull((Object)entry.getMethodSignature());
        entry.setMethodSignature("createButton()");
        InstanceFactoryEntryInfoTest.assertEquals((Object)"createButton()", (Object)entry.getMethodSignature());
        InstanceFactoryEntryInfoTest.assertEquals((Object)"InstanceFactoryMethod(class='test.InstanceFactory' signature='createButton()')", (Object)entry.toString());
    }

    @Test
    public void test_parse_defaults() throws Exception {
        InstanceFactoryEntryInfoTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        InstanceFactoryEntryInfoTest.waitForAutoBuild();
        InstanceFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <instance-factory class='test.InstanceFactory'>", "    <method signature='createButton()'/>", "  </instance-factory>", "</category>"});
        PaletteInfo palette = this.loadPalette();
        CategoryInfo category = palette.getCategory("category_1");
        InstanceFactoryEntryInfo entry = (InstanceFactoryEntryInfo)category.getEntries().get(0);
        InstanceFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, this.m_lastParseInfo));
        InstanceFactoryEntryInfoTest.assertSame((Object)category, (Object)entry.getCategory());
        InstanceFactoryEntryInfoTest.assertEquals((Object)"test.InstanceFactory", (Object)entry.getFactoryClassName());
        InstanceFactoryEntryInfoTest.assertEquals((Object)"createButton()", (Object)entry.getMethodSignature());
        InstanceFactoryEntryInfoTest.assertEquals((Object)"category_1 test.InstanceFactory createButton()", (Object)entry.getId());
        InstanceFactoryEntryInfoTest.assertEquals((Object)"createButton()", (Object)entry.getName());
        InstanceFactoryEntryInfoTest.assertEquals((Object)"Class: test.InstanceFactory<br/>Method: createButton()", (Object)entry.getDescription());
    }

    @Test
    public void test_createTool_new() throws Exception {
        InstanceFactoryEntryInfoTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        InstanceFactoryEntryInfoTest.waitForAutoBuild();
        InstanceFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <instance-factory class='test.InstanceFactory'>", "    <method signature='createButton()'/>", "  </instance-factory>", "</category>"});
        JavaInfo panel = this.parseEmptyPanel();
        PaletteInfo palette = this.loadPalette(panel);
        CategoryInfo category = palette.getCategory("category_1");
        InstanceFactoryEntryInfo entry = (InstanceFactoryEntryInfo)category.getEntries().get(0);
        InstanceFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, panel));
        CreationTool creationTool = (CreationTool)entry.createTool();
        this.assertEditor("// filler filler filler", "public class Test extends JPanel {", "  private final InstanceFactory instanceFactory = new InstanceFactory();", "  public Test() {", "  }", "}");
        InstanceFactoryInfo instanceFactory = this.getTestInstanceFactories().get(0);
        ICreationFactory factory = creationTool.getFactory();
        factory.activate();
        JavaInfo javaInfo = (JavaInfo)factory.getNewObject();
        InstanceFactoryCreationSupport creationSupport = (InstanceFactoryCreationSupport)javaInfo.getCreationSupport();
        InstanceFactoryEntryInfoTest.assertEquals((Object)TemplateUtils.format((String)"{0}.createButton()", (Object[])new Object[]{instanceFactory}), (Object)creationSupport.add_getSource(null));
    }

    @Test
    public void test_createTool_single() throws Exception {
        InstanceFactoryEntryInfoTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        InstanceFactoryEntryInfoTest.waitForAutoBuild();
        InstanceFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <instance-factory class='test.InstanceFactory'>", "    <method signature='createButton()'/>", "  </instance-factory>", "</category>"});
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final InstanceFactory myFactory = new InstanceFactory();", "  public Test() {", "  }", "}");
        InstanceFactoryInfo instanceFactory = this.getTestInstanceFactories().get(0);
        String initialSource = this.m_lastEditor.getSource();
        PaletteInfo palette = this.loadPalette((JavaInfo)panel);
        CategoryInfo category = palette.getCategory("category_1");
        InstanceFactoryEntryInfo entry = (InstanceFactoryEntryInfo)category.getEntries().get(0);
        InstanceFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, (JavaInfo)panel));
        CreationTool creationTool = (CreationTool)entry.createTool();
        InstanceFactoryEntryInfoTest.assertEditor(initialSource, this.m_lastEditor);
        ICreationFactory factory = creationTool.getFactory();
        factory.activate();
        JavaInfo javaInfo = (JavaInfo)factory.getNewObject();
        InstanceFactoryEntryInfoTest.assertSame((Object)Boolean.TRUE, (Object)javaInfo.getArbitraryValue((Object)"manuallyCreatedComponent"));
        InstanceFactoryCreationSupport creationSupport = (InstanceFactoryCreationSupport)javaInfo.getCreationSupport();
        InstanceFactoryEntryInfoTest.assertEquals((Object)TemplateUtils.format((String)"{0}.createButton()", (Object[])new Object[]{instanceFactory}), (Object)creationSupport.add_getSource(null));
    }

    @Test
    public void test_createTool_multiSelect() throws Exception {
        InstanceFactoryEntryInfoTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        InstanceFactoryEntryInfoTest.waitForAutoBuild();
        InstanceFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <instance-factory class='test.InstanceFactory'>", "    <method signature='createButton()'/>", "  </instance-factory>", "</category>"});
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final InstanceFactory factory_1 = new InstanceFactory();", "  private final InstanceFactory factory_2 = new InstanceFactory();", "  public Test() {", "  }", "}");
        String initialSource = this.m_lastEditor.getSource();
        PaletteInfo palette = this.loadPalette((JavaInfo)panel);
        CategoryInfo category = palette.getCategory("category_1");
        final InstanceFactoryEntryInfo entry = (InstanceFactoryEntryInfo)category.getEntries().get(0);
        InstanceFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, (JavaInfo)panel));
        final CreationTool[] tools = new CreationTool[1];
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                tools[0] = (CreationTool)entry.createTool();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Select factory").bot();
                SWTBotTable table = shell.table();
                table.select(new int[]{1});
                shell.button("OK").click();
            }
        });
        CreationTool creationTool = tools[0];
        InstanceFactoryInfo instanceFactory = this.getTestInstanceFactories().get(1);
        InstanceFactoryEntryInfoTest.assertEditor(initialSource, this.m_lastEditor);
        ICreationFactory factory = creationTool.getFactory();
        factory.activate();
        JavaInfo javaInfo = (JavaInfo)factory.getNewObject();
        InstanceFactoryCreationSupport creationSupport = (InstanceFactoryCreationSupport)javaInfo.getCreationSupport();
        InstanceFactoryEntryInfoTest.assertEquals((Object)TemplateUtils.format((String)"{0}.createButton()", (Object[])new Object[]{instanceFactory}), (Object)creationSupport.add_getSource(null));
    }

    @Test
    public void test_createTool_multiCancel() throws Exception {
        InstanceFactoryEntryInfoTest.setFileContentSrc("test/InstanceFactory.java", this.getTestSource("public final class InstanceFactory {", "  public JButton createButton() {", "    return new JButton();", "  }", "}"));
        InstanceFactoryEntryInfoTest.waitForAutoBuild();
        InstanceFactoryEntryInfoTest.addPaletteExtension(new String[]{"<category id='category_1' name='category 1'>", "  <instance-factory class='test.InstanceFactory'>", "    <method signature='createButton()'/>", "  </instance-factory>", "</category>"});
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private final InstanceFactory factory_1 = new InstanceFactory();", "  private final InstanceFactory factory_2 = new InstanceFactory();", "  public Test() {", "  }", "}");
        String initialSource = this.m_lastEditor.getSource();
        PaletteInfo palette = this.loadPalette((JavaInfo)panel);
        CategoryInfo category = palette.getCategory("category_1");
        final InstanceFactoryEntryInfo entry = (InstanceFactoryEntryInfo)category.getEntries().get(0);
        InstanceFactoryEntryInfoTest.assertTrue((boolean)entry.initialize(null, (JavaInfo)panel));
        final CreationTool[] tools = new CreationTool[1];
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                tools[0] = (CreationTool)entry.createTool();
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Select factory").bot();
                shell.button("Cancel").click();
            }
        });
        CreationTool creationTool = tools[0];
        InstanceFactoryEntryInfoTest.assertEditor(initialSource, this.m_lastEditor);
        InstanceFactoryEntryInfoTest.assertNull((Object)creationTool);
    }

    private List<InstanceFactoryInfo> getTestInstanceFactories() throws Exception {
        return InstanceFactoryInfo.getFactories((JavaInfo)this.m_lastParseInfo, this.m_lastLoader.loadClass("test.InstanceFactory"));
    }
}

