/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.palette;

import java.util.List;
import org.eclipse.wb.core.editor.palette.model.AbstractElementInfo;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.EntryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.PaletteManager;
import org.eclipse.wb.internal.core.editor.palette.command.CategoryAddCommand;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.ComponentAddCommand;
import org.eclipse.wb.internal.core.editor.palette.command.ComponentEditCommand;
import org.eclipse.wb.internal.core.editor.palette.command.ElementVisibilityCommand;
import org.eclipse.wb.internal.core.editor.palette.command.EntryMoveCommand;
import org.eclipse.wb.internal.core.editor.palette.command.EntryRemoveCommand;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.palette.AbstractPaletteTest;
import org.junit.jupiter.api.Test;

public class ComponentCommandsTest
extends AbstractPaletteTest {
    @Test
    public void test_add() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("new id", "new name", "new description", true, "javax.swing.JButton", category));
        manager.commands_write();
        ComponentEntryInfo entry = (ComponentEntryInfo)palette.getEntry("new id");
        ComponentCommandsTest.assertEquals((Object)"new name", (Object)entry.getName());
        ComponentCommandsTest.assertEquals((Object)"new description", (Object)entry.getDescription());
        ComponentCommandsTest.assertEquals((Object)"javax.swing.JButton", (Object)entry.getClassName());
        ComponentCommandsTest.assertTrue((boolean)entry.isVisible());
        manager.reloadPalette();
        palette = manager.getPalette();
        ComponentEntryInfo entry2 = (ComponentEntryInfo)palette.getEntry("new id");
        ComponentCommandsTest.assertEquals((Object)"new name", (Object)entry2.getName());
        ComponentCommandsTest.assertEquals((Object)"new description", (Object)entry2.getDescription());
        ComponentCommandsTest.assertEquals((Object)"javax.swing.JButton", (Object)entry2.getClassName());
        ComponentCommandsTest.assertTrue((boolean)entry2.isVisible());
    }

    @Test
    public void test_edit() throws Exception {
        PaletteManager manager = this.loadManager();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        ComponentEntryInfo entry = (ComponentEntryInfo)palette.getEntry("0");
        ComponentCommandsTest.assertEquals((Object)"0", (Object)entry.getName());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)entry.getDescription());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)entry.getClassName());
        ComponentCommandsTest.assertTrue((boolean)entry.isVisible());
        manager.commands_add((Command)new ComponentEditCommand("0", "1", "1", false, "1"));
        entry = (ComponentEntryInfo)palette.getEntry("0");
        ComponentCommandsTest.assertEquals((Object)"1", (Object)entry.getName());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)entry.getDescription());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)entry.getClassName());
        ComponentCommandsTest.assertFalse((boolean)entry.isVisible());
        manager.commands_write();
        manager.reloadPalette();
        palette = manager.getPalette();
        ComponentEntryInfo entry2 = (ComponentEntryInfo)palette.getEntry("0");
        ComponentCommandsTest.assertEquals((Object)"1", (Object)entry2.getName());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)entry2.getDescription());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)entry2.getClassName());
        ComponentCommandsTest.assertFalse((boolean)entry2.isVisible());
    }

    @Test
    public void test_move_before() throws Exception {
        PaletteManager manager = this.loadManager();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category.getEntries().get(1), category, (EntryInfo)category.getEntries().get(0)));
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category2 = palette.getCategory("0");
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category2.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category2.getEntries().get(1)).getId());
    }

    @Test
    public void test_move_last() throws Exception {
        PaletteManager manager = this.loadManager();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category.getEntries().get(0), category, null));
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category2 = palette.getCategory("0");
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category2.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category2.getEntries().get(1)).getId());
    }

    @Test
    public void test_move_noop() throws Exception {
        PaletteManager manager = this.loadManager();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category.getEntries().get(1), category, (EntryInfo)category.getEntries().get(1)));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category2 = palette.getCategory("0");
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category2.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category2.getEntries().get(1)).getId());
    }

    @Test
    public void test_move_twoTimes() throws Exception {
        PaletteManager manager = this.loadManager();
        List commands = (List)ReflectionUtils.getFieldObject((Object)manager, (String)"m_commands");
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        ComponentCommandsTest.assertEquals((int)3, (int)commands.size());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category.getEntries().get(1), category, null));
        ComponentCommandsTest.assertEquals((int)4, (int)commands.size());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category.getEntries().get(1), category, null));
        ComponentCommandsTest.assertEquals((int)4, (int)commands.size());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category2 = palette.getCategory("0");
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category2.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category2.getEntries().get(1)).getId());
    }

    @Test
    public void test_move_stopIfTarget() throws Exception {
        PaletteManager manager = this.loadManager();
        List commands = (List)ReflectionUtils.getFieldObject((Object)manager, (String)"m_commands");
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        ComponentCommandsTest.assertEquals((int)3, (int)commands.size());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category.getEntries().get(0), category, null));
        ComponentCommandsTest.assertEquals((int)4, (int)commands.size());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category.getEntries().get(0), category, (EntryInfo)category.getEntries().get(1)));
        ComponentCommandsTest.assertEquals((int)5, (int)commands.size());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category.getEntries().get(1), category, null));
        ComponentCommandsTest.assertEquals((int)6, (int)commands.size());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category2 = palette.getCategory("0");
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category2.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category2.getEntries().get(1)).getId());
    }

    @Test
    public void test_move_noSource() throws Exception {
        PaletteManager manager = this.loadManager();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        EntryMoveCommand moveCommand = new EntryMoveCommand((EntryInfo)category.getEntries().get(1), category, null);
        ReflectionUtils.setField((Object)moveCommand, (String)"m_id", (Object)"no-such-entry");
        manager.commands_add((Command)moveCommand);
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category2 = palette.getCategory("0");
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category2.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category2.getEntries().get(1)).getId());
    }

    @Test
    public void test_move_noTargetCategory() throws Exception {
        PaletteManager manager = this.loadManager();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        EntryMoveCommand moveCommand = new EntryMoveCommand((EntryInfo)category.getEntries().get(1), category, null);
        ReflectionUtils.setField((Object)moveCommand, (String)"m_categoryId", (Object)"no-such-category");
        manager.commands_add((Command)moveCommand);
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category2 = palette.getCategory("0");
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category2.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category2.getEntries().get(1)).getId());
    }

    @Test
    public void test_move_otherCategory() throws Exception {
        PaletteManager manager = this.loadManager();
        CategoryInfo category_0 = ComponentCommandsTest.addCategory(manager, "0");
        CategoryInfo category_1 = ComponentCommandsTest.addCategory(manager, "1");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category_0));
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category_1));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category_0.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category_1.getEntries().get(0)).getId());
        manager.commands_add((Command)new EntryMoveCommand((EntryInfo)category_1.getEntries().get(0), category_0, null));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category_0.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category_0.getEntries().get(1)).getId());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        CategoryInfo category = palette.getCategory("0");
        ComponentCommandsTest.assertNotNull((Object)palette.getCategory("1"));
        ComponentCommandsTest.assertEquals((Object)"0", (Object)((EntryInfo)category.getEntries().get(0)).getId());
        ComponentCommandsTest.assertEquals((Object)"1", (Object)((EntryInfo)category.getEntries().get(1)).getId());
    }

    @Test
    public void test_remove() throws Exception {
        PaletteManager manager = this.loadManager();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("0", "0", "0", true, "0", category));
        ComponentCommandsTest.assertEquals((int)1, (int)category.getEntries().size());
        manager.commands_add((Command)new EntryRemoveCommand((EntryInfo)category.getEntries().get(0)));
        ComponentCommandsTest.assertEquals((int)0, (int)category.getEntries().size());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        ComponentCommandsTest.assertNull((Object)palette.getEntry("0"));
    }

    @Test
    public void test_visibility() throws Exception {
        PaletteManager manager = this.loadManager();
        CategoryInfo category = ComponentCommandsTest.addCategory(manager, "0");
        manager.commands_add((Command)new ComponentAddCommand("1", "1", "1", true, "1", category));
        EntryInfo entry = (EntryInfo)category.getEntries().get(0);
        ComponentCommandsTest.assertTrue((boolean)entry.isVisible());
        manager.commands_add((Command)new ElementVisibilityCommand((AbstractElementInfo)entry, false));
        ComponentCommandsTest.assertFalse((boolean)entry.isVisible());
        manager.commands_write();
        manager.reloadPalette();
        PaletteInfo palette = manager.getPalette();
        ComponentCommandsTest.assertFalse((boolean)palette.getEntry("1").isVisible());
    }

    private static CategoryInfo addCategory(PaletteManager manager, String id) {
        PaletteInfo palette = manager.getPalette();
        manager.commands_add((Command)new CategoryAddCommand(id, "0", "0", true, true, null));
        return palette.getCategory(id);
    }
}

