/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.property.editor;

import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.LongObjectPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.property.editor.AbstractTextPropertyEditorTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.Test;

public class LongObjectPropertyEditorTest
extends AbstractTextPropertyEditorTest {
    private static final LongObjectPropertyEditor EDITOR = LongObjectPropertyEditor.INSTANCE;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_getText() throws Exception {
        LongObjectPropertyEditorTest.assert_getText(null, (TextDisplayPropertyEditor)EDITOR, Property.UNKNOWN_VALUE);
        LongObjectPropertyEditorTest.assert_getText("null", (TextDisplayPropertyEditor)EDITOR, null);
        LongObjectPropertyEditorTest.assert_getText("123", (TextDisplayPropertyEditor)EDITOR, 123L);
    }

    @Test
    public void test_getEditorText() throws Exception {
        LongObjectPropertyEditorTest.assert_getEditorText(null, (TextDisplayPropertyEditor)EDITOR, Property.UNKNOWN_VALUE);
        LongObjectPropertyEditorTest.assert_getEditorText("null", (TextDisplayPropertyEditor)EDITOR, null);
        LongObjectPropertyEditorTest.assert_getEditorText("123", (TextDisplayPropertyEditor)EDITOR, 123L);
    }

    @Test
    public void test_setEditorText_value() throws Exception {
        this.prepareLongPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        LongObjectPropertyEditorTest.setTextEditorText(property, "123");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(123L);", "  }", "}");
    }

    @Test
    public void test_setEditorText_null() throws Exception {
        this.prepareLongPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        LongObjectPropertyEditorTest.setTextEditorText(property, "null");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo((Long) null);", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_emptyString() throws Exception {
        this.prepareLongPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(123L);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        LongObjectPropertyEditorTest.setTextEditorText(property, "");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_removeValue_whitespaceString() throws Exception {
        this.prepareLongPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "    setFoo(123L);", "  }", "}");
        panel.refresh();
        Property property = panel.getPropertyByTitle("foo");
        LongObjectPropertyEditorTest.setTextEditorText(property, " ");
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_setEditorText_invalidValue() throws Exception {
        this.prepareLongPanel();
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
        panel.refresh();
        final Property property = panel.getPropertyByTitle("foo");
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                LongObjectPropertyEditorTest.setTextEditorText(property, "notLong");
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("foo").bot();
                shell.button("OK").click();
            }
        });
        this.assertEditor("// filler filler filler", "public class Test extends MyPanel {", "  public Test() {", "  }", "}");
    }

    private void prepareLongPanel() throws Exception {
        LongObjectPropertyEditorTest.setFileContentSrc("test/MyPanel.java", this.getTestSource("public class MyPanel extends JPanel {", "  public void setFoo(Long foo) {", "  }", "}"));
        LongObjectPropertyEditorTest.waitForAutoBuild();
    }
}

