/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import junit.framework.Test;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;
import org.eclipse.wst.jsdt.internal.core.dom.rewrite.SourceModifier;

public class SourceModifierTest
extends ASTRewritingTest {
    private static final Class THIS = SourceModifierTest.class;

    public SourceModifierTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return SourceModifierTest.allTests();
    }

    public void testRemoveIndents() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        Document buffer = new Document(buf.toString());
        int offset = buf.toString().indexOf("while");
        int length = buf.toString().indexOf("return;") + "return;".length() - offset;
        String content = buffer.get(offset, length);
        SourceModifier modifier = new SourceModifier(2, "    ", 4, 4);
        MultiTextEdit edit = new MultiTextEdit(0, content.length());
        ReplaceEdit[] replaces = modifier.getModifications(content);
        int i = 0;
        while (i < replaces.length) {
            edit.addChild((TextEdit)replaces[i]);
            ++i;
        }
        Document innerBuffer = new Document(content);
        edit.apply((IDocument)innerBuffer);
        buffer.replace(offset, length, innerBuffer.get());
        String preview = buffer.get();
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("        foo();\n");
        buf.append("        i++; // comment\n");
        buf.append("        i++;\n");
        buf.append("    }\n");
        buf.append("    return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        String expected = buf.toString();
        SourceModifierTest.assertEqualString(preview, expected);
    }

    public void testAddIndents() throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("            foo();\n");
        buf.append("            i++; // comment\n");
        buf.append("            i++;\n");
        buf.append("        }\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        Document buffer = new Document(buf.toString());
        int offset = buf.toString().indexOf("while");
        int length = buf.toString().indexOf("return;") + "return;".length() - offset;
        String content = buffer.get(offset, length);
        SourceModifier modifier = new SourceModifier(2, "            ", 4, 4);
        MultiTextEdit edit = new MultiTextEdit(0, content.length());
        ReplaceEdit[] replaces = modifier.getModifications(content);
        int i = 0;
        while (i < replaces.length) {
            edit.addChild((TextEdit)replaces[i]);
            ++i;
        }
        Document innerBuffer = new Document(content);
        edit.apply((IDocument)innerBuffer);
        buffer.replace(offset, length, innerBuffer.get());
        String preview = buffer.get();
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        while (i == 0) {\n");
        buf.append("                foo();\n");
        buf.append("                i++; // comment\n");
        buf.append("                i++;\n");
        buf.append("            }\n");
        buf.append("            return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        String expected = buf.toString();
        SourceModifierTest.assertEqualString(preview, expected);
    }
}

