/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.jsp;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.designtime.internal.jsp.JSPModelProcessor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class StartupHandler
implements IStartup {
    private final JSPEditorListener _partListener = new JSPEditorListener();
    private static final boolean DISABLE_EDITOR_OPEN_REFRESH = System.getProperty("org.eclipse.jst.jsf.jspmodelprocessor.disable.editor.open.refresh") != null;

    public void earlyStartup() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] windows;
                IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = windows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] pages;
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                    int n3 = pages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference[] editorReferences;
                        IWorkbenchPage page = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                        int n5 = editorReferences.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editorReference = iEditorReferenceArray[n6];
                            if (StartupHandler.this._partListener.isValidJSPEditor(editorReference)) {
                                StartupHandler.this._partListener.setJSPModelListener(editorReference);
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    window.getPartService().addPartListener((IPartListener2)StartupHandler.this._partListener);
                    ++n2;
                }
                PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowActivated(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                        window.getPartService().removePartListener((IPartListener2)(this).StartupHandler.this._partListener);
                    }

                    public void windowOpened(IWorkbenchWindow window) {
                        window.getPartService().addPartListener((IPartListener2)(this).StartupHandler.this._partListener);
                    }
                });
            }
        });
    }

    private static class JSPEditorListener
    implements IPartListener2 {
        private JSPModelProcessor _processor;

        private JSPEditorListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            if (this.isValidJSPEditor(partRef)) {
                this.setJSPModelListener((IEditorReference)partRef);
            }
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        private boolean isJSPEditor(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            if (file != null) {
                return JSPUtil.isJSPContentType((IFile)file);
            }
            return false;
        }

        boolean isValidJSPEditor(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            return file != null && JSFAppConfigUtils.isValidJSFProject(file.getProject()) && this.isJSPEditor(editorRef);
        }

        boolean isValidJSPEditor(IWorkbenchPartReference partRef) {
            if (partRef instanceof IEditorReference) {
                return this.isValidJSPEditor((IEditorReference)partRef);
            }
            return false;
        }

        void setJSPModelListener(IEditorReference editorRef) {
            IFile file = this.getIFile(editorRef);
            if (file != null && file.isAccessible()) {
                try {
                    if (!DISABLE_EDITOR_OPEN_REFRESH) {
                        this._processor = JSPModelProcessor.get(file);
                        this._processor.refresh(false, JSPModelProcessor.RUN_ON_CURRENT_THREAD);
                    }
                }
                catch (Exception e) {
                    JSFCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Error acquiring model processor", (Throwable)e));
                }
            }
        }

        IFile getIFile(IEditorReference editorRef) {
            try {
                IEditorInput editorInput = editorRef.getEditorInput();
                Object adapt = editorInput.getAdapter(IFile.class);
                if (adapt instanceof IFile) {
                    return (IFile)adapt;
                }
            }
            catch (PartInitException excp) {
                JSFCorePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.jst.jsf.core", 0, "Error acquiring editor input", (Throwable)excp));
            }
            return null;
        }
    }
}

