/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.facets;

import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.ws.jaxws.utils.ContractChecker;
import org.eclipse.jst.ws.jaxws.utils.facets.IFacetUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetUtils
implements IFacetUtils {
    public boolean hasAnyFacet(IProject project, String ... facetIds) throws CoreException {
        ContractChecker.nullCheckParam(project);
        ContractChecker.nullCheckParam(facetIds);
        if (!this.isFacetedProject(project)) {
            return false;
        }
        IFacetedProject facetedProject = this.getFacetedProject(project);
        String[] stringArray = facetIds;
        int n = facetIds.length;
        int n2 = 0;
        while (n2 < n) {
            String facetId = stringArray[n2];
            IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facetId);
            if (facetedProject.hasProjectFacet(facet)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean hasFacetWithVersion(IProject project, String facetVersion, String facetId) throws CoreException {
        return this.hasFacetWithVersion(project, facetVersion, facetId, true);
    }

    @Override
    public boolean isFacetedProject(IProject project) throws CoreException {
        Set<IFacetedProject> facetedProjects = this.getAllWorkspaceFacetedProjects();
        for (IFacetedProject fp : facetedProjects) {
            if (!project.equals((Object)fp.getProject())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFacetWithVersion(IProject project, String facetVersion, String facetId, boolean acceptHigherFacetVersion) throws CoreException {
        ContractChecker.nullCheckParam(project);
        ContractChecker.nullCheckParam(facetVersion);
        ContractChecker.nullCheckParam(facetId);
        if (!this.isFacetedProject(project)) {
            return false;
        }
        Set<IProjectFacetVersion> allFacetsVersions = this.getProjectFacets(project);
        for (IProjectFacetVersion ver : allFacetsVersions) {
            if (!ver.getProjectFacet().getId().equals(facetId)) continue;
            return this.isFacetAcceptable(ver, facetVersion, acceptHigherFacetVersion);
        }
        return false;
    }

    private boolean isFacetAcceptable(IProjectFacetVersion facetVersion, String facetVersionId, boolean acceptHigherFacetVersion) throws CoreException {
        String currentFacetVersion;
        assert (facetVersion != null);
        if (!acceptHigherFacetVersion) {
            return facetVersion.getVersionString().equals(facetVersionId);
        }
        Comparator comparator = facetVersion.getProjectFacet().getVersionComparator();
        return comparator.compare(currentFacetVersion = facetVersion.getVersionString(), facetVersionId) >= 0;
    }

    private IFacetedProject getFacetedProject(IProject project) throws CoreException {
        return ProjectFacetsManager.create((IProject)project);
    }

    private Set<IProjectFacetVersion> getProjectFacets(IProject project) throws CoreException {
        assert (this.isFacetedProject(project));
        return this.getFacetedProject(project).getProjectFacets();
    }

    private Set<IFacetedProject> getAllWorkspaceFacetedProjects() throws CoreException {
        return ProjectFacetsManager.getFacetedProjects();
    }
}

