/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal;

import org.eclipse.jpt.common.ui.internal.jface.ModelItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemTreeContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.NullItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.NullItemTreeContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnum;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnumMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;

public abstract class AbstractNavigatorItemContentProviderFactory
implements ItemTreeContentProvider.Factory {
    protected AbstractNavigatorItemContentProviderFactory() {
    }

    public ItemStructuredContentProvider buildProvider(Object input, ItemStructuredContentProvider.Manager manager) {
        if (input instanceof JaxbContextRoot) {
            return this.buildItemStructuredContentProvider(input, this.buildJaxbContextRootChildrenModel((JaxbContextRoot)input), manager);
        }
        if (input instanceof JaxbPackage) {
            return this.buildItemStructuredContentProvider(input, this.buildJaxbPackageChildrenModel((JaxbPackage)input), manager);
        }
        if (input instanceof JavaClass) {
            return this.buildItemStructuredContentProvider(input, this.buildJavaClassChildrenModel((JavaClass)input), manager);
        }
        if (input instanceof JavaEnum) {
            return this.buildItemStructuredContentProvider(input, this.buildJavaEnumChildrenModel((JavaEnum)input), manager);
        }
        return NullItemStructuredContentProvider.instance();
    }

    protected ItemStructuredContentProvider buildItemStructuredContentProvider(Object input, CollectionValueModel<?> childrenModel, ItemStructuredContentProvider.Manager manager) {
        return new ModelItemStructuredContentProvider(input, childrenModel, manager);
    }

    public ItemTreeContentProvider buildProvider(Object item, Object parent, ItemTreeContentProvider.Manager manager) {
        if (item instanceof JaxbContextRoot) {
            return this.buildItemTreeContentProvider(item, parent, this.buildJaxbContextRootChildrenModel((JaxbContextRoot)item), manager);
        }
        if (item instanceof JaxbPackage) {
            return this.buildItemTreeContentProvider(item, parent, this.buildJaxbPackageChildrenModel((JaxbPackage)item), manager);
        }
        if (item instanceof JavaClass) {
            return this.buildItemTreeContentProvider(item, parent, this.buildJavaClassChildrenModel((JavaClass)item), manager);
        }
        if (item instanceof JavaEnum) {
            return this.buildItemTreeContentProvider(item, parent, this.buildJavaEnumChildrenModel((JavaEnum)item), manager);
        }
        return NullItemTreeContentProvider.instance();
    }

    protected ItemTreeContentProvider buildItemTreeContentProvider(Object item, Object parent, CollectionValueModel<?> childrenModel, ItemTreeContentProvider.Manager manager) {
        return new ModelItemTreeContentProvider(item, parent, childrenModel, manager);
    }

    protected CollectionValueModel<JaxbPackage> buildJaxbContextRootChildrenModel(JaxbContextRoot item) {
        return new CollectionAspectAdapter<JaxbContextRoot, JaxbPackage>("packages", item){

            protected Iterable<JaxbPackage> getIterable() {
                return ((JaxbContextRoot)this.subject).getPackages();
            }
        };
    }

    protected CollectionValueModel<JaxbContextNode> buildJaxbPackageChildrenModel(final JaxbPackage jaxbPackage) {
        return new CollectionAspectAdapter<JaxbContextRoot, JaxbContextNode>("javaTypes", jaxbPackage.getContextRoot()){

            protected Iterable<JaxbContextNode> getIterable() {
                return IterableTools.upCast((Iterable)((JaxbContextRoot)this.subject).getJavaTypes(jaxbPackage));
            }
        };
    }

    protected CollectionValueModel<?> buildJavaClassChildrenModel(JavaClass javaClass) {
        PropertyValueModel<JavaClassMapping> mappingModel = this.buildMappingModel(javaClass);
        return CompositeCollectionValueModel.forModels((CollectionValueModel[])new CollectionValueModel[]{this.buildAttributesModel(mappingModel), this.buildIncludedAttributesModel(mappingModel)});
    }

    protected PropertyValueModel<JavaClassMapping> buildMappingModel(JavaClass javaClass) {
        return new PropertyAspectAdapter<JavaClass, JavaClassMapping>("mapping", javaClass){

            protected JavaClassMapping buildValue_() {
                return ((JavaClass)this.subject).getMapping();
            }
        };
    }

    protected CollectionValueModel<JavaPersistentAttribute> buildAttributesModel(PropertyValueModel<JavaClassMapping> mappingModel) {
        return new CollectionAspectAdapter<JavaClassMapping, JavaPersistentAttribute>(mappingModel, new String[]{"attributes"}){

            protected Iterable<JavaPersistentAttribute> getIterable() {
                return ((JavaClassMapping)this.subject).getAttributes();
            }
        };
    }

    protected CollectionValueModel<JaxbPersistentAttribute> buildIncludedAttributesModel(PropertyValueModel<JavaClassMapping> mappingModel) {
        return new CollectionAspectAdapter<JavaClassMapping, JaxbPersistentAttribute>(mappingModel, new String[]{"includedAttributes"}){

            protected Iterable<JaxbPersistentAttribute> getIterable() {
                return ((JavaClassMapping)this.subject).getIncludedAttributes();
            }
        };
    }

    protected CollectionValueModel<?> buildJavaEnumChildrenModel(JavaEnum javaEnum) {
        return new CollectionAspectAdapter<JavaEnumMapping, JaxbEnumConstant>(this.buildMappingModel(javaEnum), new String[]{"enumConstants"}){

            protected Iterable<JaxbEnumConstant> getIterable() {
                return ((JavaEnumMapping)this.subject).getEnumConstants();
            }
        };
    }

    protected PropertyValueModel<JavaEnumMapping> buildMappingModel(JavaEnum javaEnum) {
        return new PropertyAspectAdapter<JavaEnum, JavaEnumMapping>("mapping", javaEnum){

            protected JavaEnumMapping buildValue_() {
                return ((JavaEnum)this.subject).getMapping();
            }
        };
    }
}

