/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.DomPackage;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.WebParamKind;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.annotation.AnnotationAdapterFactory;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.annotation.IAnnotationAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.AbstractSerializerAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.util.Jee5DomUtils;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;

public class ParameterSerializerAdapter
extends AbstractSerializerAdapter {
    private final Jee5DomUtils jee5Utils = Jee5DomUtils.getInstance();

    public ParameterSerializerAdapter(JaxWsWorkspaceResource resource) {
        super(resource);
    }

    @Override
    public void notifyChanged(Notification msg) {
        if (!this.resource().isSaveEnabled()) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)msg.getFeature();
        if (feature.getFeatureID() == 1) {
            try {
                this.changePartName(msg);
            }
            catch (JavaModelException e) {
                new Logger().logError(e.getMessage(), (Throwable)e);
            }
        }
        super.notifyChanged(msg);
    }

    private void changePartName(Notification msg) throws JavaModelException {
        IAnnotationAdapter annAdapter;
        IAnnotation<? extends IJavaElement> ann;
        IWebParam webParam = (IWebParam)this.getTarget();
        if (this.jee5Utils.isPartNameUsed(webParam) && (ann = (annAdapter = (IAnnotationAdapter)AnnotationAdapterFactory.INSTANCE.adapt((Notifier)webParam, IAnnotationAdapter.class)).getAnnotation("javax.jws.WebParam")) != null && ann.getPropertyValue("partName") != null) {
            return;
        }
        if (this.checkValue(msg)) {
            this.putValue(webParam, (EStructuralFeature)DomPackage.Literals.IWEB_PARAM__PART_NAME, msg.getNewValue());
        }
    }

    @Override
    protected boolean isAnnotationRequired() {
        return false;
    }

    @Override
    protected IAnnotation<? extends IJavaElement> getAnnotation() throws JavaModelException {
        IWebParam webParam = (IWebParam)this.getTarget();
        IWebMethod webMethod = (IWebMethod)webParam.eContainer();
        if (webMethod == null || webMethod.eContainer() == null) {
            return null;
        }
        IType seiType = this.findType(webMethod, ((IServiceEndpointInterface)webMethod.eContainer()).getImplementation());
        IMethod method = this.util().findMethod(seiType, webMethod);
        return AnnotationFactory.createAnnotation((String)"javax.jws.WebParam", (IJavaElement)method.getTypeParameter(webParam.getImplementation()), this.defineParamValues(webParam, webMethod));
    }

    protected Set<IParamValuePair> defineParamValues(IWebParam webParam, IWebMethod webMethod) {
        TreeSet<IParamValuePair> valuePairs = this.createParamValueSortedTreeSet();
        if (webParam.getKind() != WebParamKind.IN) {
            valuePairs.add(this.createModeValuePair(webParam));
        }
        if (webParam.isHeader()) {
            valuePairs.add(this.createParamValue("header", true));
        }
        String defName = this.defCalc().calcWebParamDefaultName(webParam);
        if (this.jee5Utils.isNameRequired(webParam) || !webParam.getName().equals(defName) && this.jee5Utils.isNameUsed(webParam)) {
            valuePairs.add(this.createParamValue("name", webParam.getName()));
        }
        if (this.jee5Utils.isPartNameUsed(webParam) && !webParam.getPartName().equals(defName)) {
            valuePairs.add(this.createParamValue("partName", webParam.getPartName()));
        }
        if (webParam.getTargetNamespace() != null) {
            String defNs = this.defCalc().calcWebParamDefaultTargetNS(webMethod, webParam);
            if (webParam.getTargetNamespace().trim().length() != 0 && !webParam.getTargetNamespace().equals(defNs)) {
                valuePairs.add(this.createParamValue("targetNamespace", webParam.getTargetNamespace()));
            }
        }
        return valuePairs;
    }

    protected IParamValuePair createModeValuePair(IWebParam webParam) {
        IValue value = null;
        switch (webParam.getKind()) {
            case OUT: {
                value = AnnotationFactory.createQualifiedNameValue((String)"javax.jws.WebParam.Mode.OUT");
                break;
            }
            case INOUT: {
                value = AnnotationFactory.createQualifiedNameValue((String)"javax.jws.WebParam.Mode.INOUT");
                break;
            }
            default: {
                return null;
            }
        }
        return AnnotationFactory.createParamValuePairValue((String)"mode", (IValue)value);
    }

    protected boolean hasParamWithSameName(IWebParam param, String newName) {
        IWebMethod webMethod = (IWebMethod)param.eContainer();
        for (IWebParam webParam : webMethod.getParameters()) {
            if (webParam == param || !webParam.getName().equals(newName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkValue(Notification msg) {
        if (((EStructuralFeature)msg.getFeature()).getFeatureID() == 5) {
            return true;
        }
        return super.checkValue(msg);
    }
}

