/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.annotations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.ClassValueImpl;

public class ClassValueImplTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void setUp() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
    }

    public void testIntegers() throws Exception {
        this.setUp();
        ClassValueImpl cv = new ClassValueImpl(this.endpoint.getFullyQualifiedName());
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)cv));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)this.endpoint);
        Collection annotattions = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        ClassValueImplTest.assertNotNull((Object)annotattions);
        ClassValueImplTest.assertTrue((annotattions.size() == 1 ? 1 : 0) != 0);
        IAnnotation readAnnotation = (IAnnotation)annotattions.iterator().next();
        readAnnotation.equals(ann);
        ClassValueImplTest.assertEquals((String)ann.getPropertyValue("param").toString(), (String)this.endpoint.getFullyQualifiedName());
        AnnotationWriter.getInstance().remove(ann);
        annotattions = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        ClassValueImplTest.assertNotNull((Object)annotattions);
        ClassValueImplTest.assertTrue((annotattions.size() == 0 ? 1 : 0) != 0);
    }

    public void testEqualsObject() {
        ClassValueImpl cv1 = new ClassValueImpl(this.endpoint.getFullyQualifiedName());
        ClassValueImpl cv2 = new ClassValueImpl(null);
        ClassValueImpl cv3 = new ClassValueImpl(this.endpoint.getFullyQualifiedName());
        ClassValueImplTest.assertFalse((boolean)cv1.equals(null));
        ClassValueImplTest.assertFalse((boolean)cv1.equals((Object)true));
        ClassValueImplTest.assertFalse((boolean)cv1.equals((Object)cv2));
        ClassValueImplTest.assertTrue((boolean)cv1.equals((Object)cv3));
        ClassValueImplTest.assertTrue((boolean)cv1.equals((Object)cv1));
    }
}

