/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFStream;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.EventDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFJsonMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypedefParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event.EventDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;

public final class EventParser
extends AbstractScopedCommonTreeParser {
    public static final EventParser INSTANCE = new EventParser();

    private EventParser() {
    }

    @Override
    public EventDeclaration parse(ICTFMetadataNode eventNode, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        Param parameter = (Param)param;
        CTFTrace trace = ((Param)param).fTrace;
        EventDeclaration event = new EventDeclaration();
        DeclarationScope scope = new DeclarationScope(parameter.fCurrentScope, "event");
        if (eventNode instanceof CTFJsonMetadataNode) {
            EventDeclarationParser.INSTANCE.parse(eventNode, new EventDeclarationParser.Param(trace, event, scope));
        } else {
            List<ICTFMetadataNode> children = eventNode.getChildren();
            if (children == null) {
                throw new ParseException("Empty event block");
            }
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[111].equals(type)) {
                    TypeAliasParser.INSTANCE.parse(child, new TypeAliasParser.Param(trace, scope));
                    continue;
                }
                if (CTFParser.tokenNames[114].equals(type)) {
                    TypedefParser.INSTANCE.parse(child, new TypedefParser.Param(trace, scope));
                    continue;
                }
                if (CTFParser.tokenNames[85].equals(type) || CTFParser.tokenNames[86].equals(type)) {
                    EventDeclarationParser.INSTANCE.parse(child, new EventDeclarationParser.Param(trace, event, scope));
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
        }
        if (!event.nameIsSet()) {
            throw new ParseException("Event name not set");
        }
        if (!event.streamIsSet()) {
            if (trace.nbStreams() > 1) {
                throw new ParseException("Event without stream_id with more than one stream");
            }
            ICTFStream iStream = trace.getStream(null);
            if (iStream instanceof CTFStream) {
                CTFStream ctfStream = (CTFStream)iStream;
                event.setStream(ctfStream);
            } else {
                throw new ParseException("Event without stream_id, but there is no stream without id");
            }
        }
        event.getStream().addEvent(event);
        return event;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fCurrentScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope currentScope) {
            this.fTrace = trace;
            this.fCurrentScope = currentScope;
        }
    }
}

