/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.renderers.swt.ContributedPartRenderer;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public abstract class WorkbenchPart
extends EventManager
implements IWorkbenchPart3,
IExecutableExtension,
IWorkbenchPartOrientation {
    private String title = "";
    private Optional<ImageDescriptor> imageDescriptor = Optional.empty();
    private Image titleImage;
    private String toolTip = "";
    private IConfigurationElement configElement;
    private IWorkbenchPartSite partSite;
    private String partName = "";
    private String contentDescription = "";
    private ListenerList<IPropertyChangeListener> partChangeListeners = new ListenerList();
    private Map<String, String> partProperties = new HashMap<String, String>();

    protected WorkbenchPart() {
    }

    @Override
    public void addPropertyListener(IPropertyListener l) {
        this.addListenerObject(l);
    }

    @Override
    public abstract void createPartControl(Composite var1);

    @Override
    public void dispose() {
        this.imageDescriptor.ifPresent(d -> {
            if (Display.getCurrent() != null) {
                JFaceResources.getResources().destroy((DeviceResourceDescriptor)d);
            }
        });
        this.titleImage = null;
        this.clearListeners();
        this.partChangeListeners.clear();
    }

    protected void firePropertyChange(int propertyId) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            IPropertyListener propertyListener = (IPropertyListener)listener;
            try {
                propertyListener.propertyChanged(this, propertyId);
            }
            catch (RuntimeException e) {
                WorkbenchPlugin.log(e);
            }
            ++n2;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.configElement;
    }

    protected Image getDefaultImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
    }

    @Override
    public IWorkbenchPartSite getSite() {
        return this.partSite;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Image getTitleImage() {
        if (this.titleImage != null) {
            return this.titleImage;
        }
        return this.getDefaultImage();
    }

    @Override
    public String getTitleToolTip() {
        return this.toolTip;
    }

    @Override
    public void removePropertyListener(IPropertyListener l) {
        this.removeListenerObject(l);
    }

    @Override
    public abstract void setFocus();

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.configElement = cfig;
        this.title = this.partName = Util.safeString(cfig.getAttribute("name"));
        String strIcon = cfig.getAttribute("icon");
        if (strIcon == null) {
            return;
        }
        this.imageDescriptor = ResourceLocator.imageDescriptorFromBundle((String)this.configElement.getContributor().getName(), (String)strIcon);
        if (!this.imageDescriptor.isPresent()) {
            ImageDescriptor shared = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(strIcon);
            this.imageDescriptor = Optional.ofNullable(shared);
        }
        this.imageDescriptor.ifPresent(d -> {
            Image image = this.titleImage = JFaceResources.getResources().createImageWithDefault(d);
        });
    }

    protected void setSite(IWorkbenchPartSite site) {
        this.checkSite(site);
        this.partSite = site;
    }

    protected void checkSite(IWorkbenchPartSite site) {
    }

    @Deprecated
    protected void setTitle(String title) {
        if (Objects.equals(this.title, title = Util.safeString(title))) {
            return;
        }
        this.title = title;
        this.firePropertyChange(1);
    }

    protected void setTitleImage(Image titleImage) {
        Assert.isTrue((titleImage == null || !titleImage.isDisposed() ? 1 : 0) != 0);
        if (this.titleImage == titleImage) {
            return;
        }
        this.titleImage = titleImage;
        this.firePropertyChange(1);
        this.imageDescriptor.ifPresent(arg_0 -> ((ResourceManager)JFaceResources.getResources()).destroy(arg_0));
        this.imageDescriptor = Optional.empty();
    }

    protected void setTitleToolTip(String toolTip) {
        if (Objects.equals(this.toolTip, toolTip = Util.safeString(toolTip))) {
            return;
        }
        this.toolTip = toolTip;
        this.firePropertyChange(1);
    }

    public void showBusy(boolean busy) {
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    protected void setPartName(String partName) {
        this.internalSetPartName(partName);
        this.setDefaultTitle();
    }

    void setDefaultTitle() {
        String name;
        String description = this.getContentDescription();
        String newTitle = name = this.getPartName();
        if (!Objects.equals(description, "")) {
            newTitle = MessageFormat.format(WorkbenchMessages.WorkbenchPart_AutoTitleFormat, name, description);
        }
        this.setTitle(newTitle);
    }

    @Override
    public String getContentDescription() {
        return this.contentDescription;
    }

    protected void setContentDescription(String description) {
        this.internalSetContentDescription(description);
        this.setDefaultTitle();
    }

    void internalSetContentDescription(String description) {
        Assert.isNotNull((Object)description);
        if (Objects.equals(this.contentDescription, description)) {
            return;
        }
        this.contentDescription = description;
        if (this.partSite instanceof PartSite) {
            PartSite site = (PartSite)this.partSite;
            ContributedPartRenderer.setDescription((MPart)site.getModel(), (String)description);
        }
        this.firePropertyChange(261);
    }

    void internalSetPartName(String partName) {
        partName = Util.safeString(partName);
        Assert.isNotNull((Object)partName);
        if (Objects.equals(this.partName, partName)) {
            return;
        }
        this.partName = partName;
        this.firePropertyChange(260);
    }

    @Override
    public int getOrientation() {
        return Window.getDefaultOrientation();
    }

    @Override
    public void addPartPropertyListener(IPropertyChangeListener listener) {
        this.partChangeListeners.add((Object)listener);
    }

    @Override
    public void removePartPropertyListener(IPropertyChangeListener listener) {
        this.partChangeListeners.remove((Object)listener);
    }

    protected void firePartPropertyChanged(String key, String oldValue, String newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, key, (Object)oldValue, (Object)newValue);
        for (IPropertyChangeListener l : this.partChangeListeners) {
            try {
                l.propertyChange(event);
            }
            catch (RuntimeException e) {
                WorkbenchPlugin.log(e);
            }
        }
    }

    @Override
    public void setPartProperty(String key, String value) {
        String oldValue = this.partProperties.get(key);
        if (value == null) {
            this.partProperties.remove(key);
        } else {
            this.partProperties.put(key, value);
        }
        this.firePartPropertyChanged(key, oldValue, value);
    }

    @Override
    public String getPartProperty(String key) {
        return this.partProperties.get(key);
    }

    @Override
    public Map<String, String> getPartProperties() {
        return Collections.unmodifiableMap(this.partProperties);
    }
}

