/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.HTNode;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfEdgeInterval;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;

public class GraphTreeNode
extends HTNode {
    private final Set<NodeClosedListener> fListeners = new HashSet<NodeClosedListener>();

    public GraphTreeNode(HTNode.NodeType type, int blockSize, int maxChildren, int seqNumber, int parentSeqNumber, long start) {
        super(type, blockSize, maxChildren, seqNumber, parentSeqNumber, start);
    }

    @Override
    protected @Nullable OverlappingExtraData createNodeExtraData(HTNode.NodeType type) {
        if (type == HTNode.NodeType.CORE) {
            return new OverlappingExtraData(this);
        }
        return null;
    }

    @Override
    public void add(TmfEdgeInterval newInterval) {
        super.add(newInterval);
    }

    @Override
    public void closeThisNode(long endtime) {
        super.closeThisNode(endtime);
        this.fListeners.forEach(l2 -> l2.nodeClosed(this, endtime));
    }

    protected void addListener(NodeClosedListener listener) {
        this.fListeners.add(listener);
    }

    @Override
    protected @Nullable OverlappingExtraData getCoreNodeData() {
        return (OverlappingExtraData)super.getCoreNodeData();
    }

    public int getNumIntervals() {
        return this.getIntervals().size();
    }

    @FunctionalInterface
    protected static interface NodeClosedListener {
        public void nodeClosed(GraphTreeNode var1, long var2);
    }

    protected static class OverlappingExtraData
    extends HTNode.CoreNodeData {
        private final long[] fChildStart;
        private final long[] fChildEnd;

        public OverlappingExtraData(GraphTreeNode node) {
            super(node);
            int size = node.getMaxChildren();
            this.fChildStart = new long[size];
            this.fChildEnd = new long[size];
            int i = 0;
            while (i < size) {
                this.fChildStart[i] = 0L;
                this.fChildEnd[i] = Long.MAX_VALUE;
                ++i;
            }
        }

        @Override
        protected GraphTreeNode getNode() {
            return (GraphTreeNode)super.getNode();
        }

        @Override
        public void readSpecificHeader(@NonNull ByteBuffer buffer) {
            super.readSpecificHeader(buffer);
            int size = this.getNode().getMaxChildren();
            int i = 0;
            while (i < size) {
                this.fChildStart[i] = buffer.getLong();
                this.fChildEnd[i] = buffer.getLong();
                ++i;
            }
        }

        @Override
        protected void writeSpecificHeader(@NonNull ByteBuffer buffer) {
            this.getNode().takeReadLock();
            try {
                super.writeSpecificHeader(buffer);
                int size = this.getNode().getMaxChildren();
                int i = 0;
                while (i < size) {
                    buffer.putLong(this.fChildStart[i]);
                    buffer.putLong(this.fChildEnd[i]);
                    ++i;
                }
            }
            finally {
                this.getNode().releaseReadLock();
            }
        }

        @Override
        protected int getSpecificHeaderSize() {
            int maxChildren = this.getNode().getMaxChildren();
            int specificSize = super.getSpecificHeaderSize();
            return specificSize += 16 * maxChildren;
        }

        @Override
        public void linkNewChild(HTNode childNode) {
            if (!(childNode instanceof GraphTreeNode)) {
                throw new IllegalArgumentException("Adding a node that is not an overlapping node to an overlapping tree!");
            }
            this.getNode().takeWriteLock();
            try {
                super.linkNewChild(childNode);
                int childIndex = this.getNbChildren() - 1;
                ((GraphTreeNode)childNode).addListener((node, endtime) -> {
                    this.getNode().takeWriteLock();
                    try {
                        this.fChildEnd[n] = endtime;
                    }
                    finally {
                        this.getNode().releaseWriteLock();
                    }
                });
                this.fChildStart[childIndex] = childNode.getNodeStart();
                if (childNode.isOnDisk()) {
                    this.fChildEnd[childIndex] = childNode.getNodeEnd();
                }
            }
            finally {
                this.getNode().releaseWriteLock();
            }
        }

        @Override
        protected Collection<Integer> selectNextIndices(TimeRangeCondition rc) {
            GraphTreeNode node = this.getNode();
            if (rc.max() < node.getNodeStart() || node.isOnDisk() && rc.min() > node.getNodeEnd()) {
                return Collections.emptySet();
            }
            node.takeReadLock();
            try {
                ArrayList<Integer> childList = new ArrayList<Integer>();
                int i = 0;
                while (i < this.getNbChildren()) {
                    if (rc.intersects(this.fChildStart[i], this.fChildEnd[i])) {
                        childList.add(i);
                    }
                    ++i;
                }
                ArrayList<Integer> arrayList = childList;
                return arrayList;
            }
            finally {
                node.releaseReadLock();
            }
        }

        public long getChildStart(int index) {
            this.getNode().takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fChildStart[index];
                return l;
            }
            finally {
                this.getNode().releaseReadLock();
            }
        }

        public long getChildEnd(int index) {
            this.getNode().takeReadLock();
            try {
                if (index >= this.getNbChildren()) {
                    throw new IndexOutOfBoundsException("The child at index " + index + " does not exist");
                }
                long l = this.fChildEnd[index];
                return l;
            }
            finally {
                this.getNode().releaseReadLock();
            }
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fChildStart, this.fChildEnd);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            OverlappingExtraData other = (OverlappingExtraData)NonNullUtils.checkNotNull((Object)obj);
            return Arrays.equals(this.fChildStart, other.fChildStart) && Arrays.equals(this.fChildEnd, other.fChildEnd);
        }
    }
}

