/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.debugger.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ease.debugging.model.EaseDebugStackFrame;
import org.eclipse.ease.debugging.model.EaseDebugVariable;
import org.eclipse.ease.lang.javascript.rhino.debugger.editor.JavaScriptWordFinder;
import org.eclipse.ease.lang.javascript.rhino.debugger.model.RhinoDebugModelPresentation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.ExpressionInformationControlCreator;
import org.eclipse.wst.jsdt.ui.text.java.hover.IJavaEditorTextHover;

public class VariablesTextHover
implements IJavaEditorTextHover,
ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private static String getVariableText(IVariable variable) {
        StringBuilder buffer = new StringBuilder();
        RhinoDebugModelPresentation modelPresentation = new RhinoDebugModelPresentation();
        buffer.append("<p><pre>");
        String variableText = modelPresentation.getText(variable);
        buffer.append(VariablesTextHover.replaceHTMLChars(variableText));
        buffer.append("</pre></p>");
        modelPresentation.dispose();
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    private static String replaceHTMLChars(String variableText) {
        char[] characters;
        StringBuffer buffer = new StringBuffer(variableText.length());
        char[] cArray = characters = variableText.toCharArray();
        int n = characters.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++n2;
        }
        return buffer.toString();
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IVariable variable = this.getHoverInfo2(textViewer, hoverRegion);
        if (variable != null) {
            return VariablesTextHover.getVariableText(variable);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaScriptWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public IVariable getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument document;
        EaseDebugStackFrame frame = this.getFrame();
        if (frame != null && (document = textViewer.getDocument()) != null) {
            try {
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                return this.findLocalVariable(frame, variableName);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        return null;
    }

    private IVariable findLocalVariable(EaseDebugStackFrame frame, String variableName) {
        if (frame != null) {
            EaseDebugVariable[] easeDebugVariableArray = frame.getVariables();
            int n = easeDebugVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                EaseDebugVariable variable = easeDebugVariableArray[n2];
                try {
                    if (variable.getName().equals(variableName)) {
                        return variable;
                    }
                }
                catch (DebugException debugException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new ExpressionInformationControlCreator();
    }

    public void setEditor(IEditorPart editor) {
    }

    private EaseDebugStackFrame getFrame() {
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof EaseDebugStackFrame) {
            return (EaseDebugStackFrame)context;
        }
        return null;
    }
}

