/*******************************************************************************
 * Copyright (c) 2005, 2023 IBM Corporation and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package swt.bugs;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class IconVsImage {

	public static void main(String[] args) {
		Display display = Display.getDefault();
		Shell shell = new Shell(display);

		Menu menu = new Menu(shell, SWT.BAR);
		shell.setMenuBar(menu);
		MenuItem file = new MenuItem(menu, SWT.CASCADE);
		file.setText("File"); //$NON-NLS-1$
		Menu fileMenu = new Menu(file);
		file.setMenu(fileMenu);
		MenuItem item1 = new MenuItem(fileMenu, 0);
		item1.setText("item 1"); //$NON-NLS-1$
		MenuItem item2 = new MenuItem(fileMenu, 0);
		item2.setText("item 2"); //$NON-NLS-1$

		Image image1 = new Image(null, IconVsImage.class.getResourceAsStream("and16.gif")); //$NON-NLS-1$
		Image image2 = new Image(null, image1.getImageData(), image1.getImageData().getTransparencyMask());

		item1.setImage(image1);
		item2.setImage(image2);

		shell.setSize(600, 500);
		shell.open();
		while (!shell.isDisposed()) {
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}

}
