/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.server;

import java.io.File;
import java.net.URI;
import java.util.Optional;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.lsp.ExistingResource;
import org.eclipse.cdt.lsp.editor.InitialUri;
import org.eclipse.cdt.lsp.internal.server.CLanguageServerEnableCache;
import org.eclipse.cdt.lsp.plugin.LspPlugin;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider;
import org.eclipse.cdt.lsp.util.LspUtils;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.lsp4e.outline.SymbolsModel;

public class HasLanguageServerPropertyTester
extends PropertyTester {
    private final ICLanguageServerProvider cLanguageServerProvider;
    private final ServiceCaller<InitialUri> initial;
    private final ServiceCaller<IWorkspace> workspace;
    private final CLanguageServerEnableCache cache = CLanguageServerEnableCache.getInstance();
    private Optional<IProject> project;

    public HasLanguageServerPropertyTester() {
        this.cLanguageServerProvider = LspPlugin.getDefault().getCLanguageServerProvider();
        this.initial = new ServiceCaller(((Object)((Object)this)).getClass(), InitialUri.class);
        this.workspace = new ServiceCaller(((Object)((Object)this)).getClass(), IWorkspace.class);
        this.project = Optional.empty();
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (this.cLanguageServerProvider != null) {
            if (receiver instanceof URI) {
                URI uri = (URI)receiver;
                Optional<Boolean> value = this.cache.get(uri);
                if (value.isPresent()) {
                    return value.get();
                }
                if (!this.validContentType(uri)) {
                    this.cache.disable(uri);
                    return false;
                }
                boolean isEnabled = this.enabledFor(uri);
                if (isEnabled) {
                    this.initial.call(iu -> iu.register(uri));
                }
                return isEnabled;
            }
            if (receiver instanceof ITranslationUnit) {
                return Optional.of((ITranslationUnit)receiver).map(ICElement::getCProject).map(ICProject::getProject).map(this.cLanguageServerProvider::isEnabledFor).orElse(Boolean.FALSE);
            }
            return receiver instanceof SymbolsModel.DocumentSymbolWithURI;
        }
        return false;
    }

    private boolean validContentType(URI uri) {
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(new File(uri.getPath()).getName());
        if (contentType != null) {
            return LspUtils.isCContentType(contentType.getId());
        }
        return false;
    }

    private void fetchProject(URI uri) {
        this.workspace.call(w -> {
            this.project = new ExistingResource((IWorkspace)w).apply(uri).map(IResource::getProject);
            Optional<IProject> optional = this.project;
        });
    }

    private boolean enabledFor(URI uri) {
        this.fetchProject(uri);
        return this.project.map(this.cLanguageServerProvider::isEnabledFor).orElseGet(() -> LspUtils.isFileOpenedInLspEditor(uri));
    }
}

