/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.cdt.debug.core.model.IConnectHandler;
import org.eclipse.cdt.debug.core.model.IDebugNewExecutableHandler;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbSessionAdapters;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.ITerminateHandler;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxyFactory;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;

@ThreadSafe
public class GdbAdapterFactory
implements IAdapterFactory,
ILaunchesListener2 {
    private static Map<GdbLaunch, GdbSessionAdapters> fgLaunchAdapterSets = Collections.synchronizedMap(new HashMap());
    private static Map<ILaunch, GdbSessionAdapters> fgDisposedLaunchAdapterSets = new WeakHashMap<ILaunch, GdbSessionAdapters>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAdapterSet(ILaunch launch) {
        Map<GdbLaunch, GdbSessionAdapters> map = fgLaunchAdapterSets;
        synchronized (map) {
            if (fgLaunchAdapterSets.containsKey(launch)) {
                fgLaunchAdapterSets.remove(launch).dispose();
                fgDisposedLaunchAdapterSets.put(launch, null);
            }
        }
    }

    public GdbAdapterFactory() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        GdbSessionAdapters adapterSet;
        block9: {
            if (!(adaptableObject instanceof GdbLaunch)) {
                return null;
            }
            GdbLaunch launch = (GdbLaunch)adaptableObject;
            DsfSession session = launch.getSession();
            if (session == null) {
                return null;
            }
            Map<GdbLaunch, GdbSessionAdapters> map = fgLaunchAdapterSets;
            synchronized (map) {
                block8: {
                    block7: {
                        if (!fgDisposedLaunchAdapterSets.containsKey(launch)) break block7;
                        return null;
                    }
                    adapterSet = fgLaunchAdapterSets.get(launch);
                    if (adapterSet != null) break block9;
                    if (session.isActive()) break block8;
                    return null;
                }
                adapterSet = this.createGdbSessionAdapters((ILaunch)launch, session);
                fgLaunchAdapterSets.put(launch, adapterSet);
            }
        }
        return adapterSet.getLaunchAdapter(adapterType);
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IElementContentProvider.class, IModelProxyFactory.class, ISuspendTrigger.class, IColumnPresentationFactory.class, ITerminateHandler.class, IConnectHandler.class, IDisconnectHandler.class, IDebugNewExecutableHandler.class};
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof GdbLaunch) {
                GdbAdapterFactory.disposeAdapterSet(launch);
            }
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    protected GdbSessionAdapters createGdbSessionAdapters(ILaunch launch, DsfSession session) {
        return new GdbSessionAdapters(launch, session, this.getAdapterList());
    }
}

