/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.ssh.launcher;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.ui.IMemento;

public class SshMementoHandler
implements IMementoHandler {
    public void saveState(IMemento memento, Map<String, Object> properties) {
        Assert.isNotNull((Object)memento);
        Assert.isNotNull(properties);
        memento.putString("ip.host", (String)properties.get("ip.host"));
        Object value = properties.get("ip.port");
        memento.putInteger("ip.port", value instanceof Integer ? (Integer)value : -1);
        value = properties.get("timeout");
        memento.putInteger("timeout", value instanceof Integer ? (Integer)value : -1);
        value = properties.get("ssh.keep_alive");
        memento.putInteger("ssh.keep_alive", value instanceof Integer ? (Integer)value : -1);
        memento.putString("ssh.user", (String)properties.get("ssh.user"));
        memento.putString("encoding", (String)properties.get("encoding"));
    }

    public void restoreState(IMemento memento, Map<String, Object> properties) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)memento);
        Assert.isNotNull(properties);
        properties.put("ip.host", memento.getString("ip.host"));
        properties.put("ip.port", memento.getInteger("ip.port"));
        properties.put("timeout", memento.getInteger("timeout"));
        properties.put("ssh.keep_alive", memento.getInteger("ssh.keep_alive"));
        properties.put("ssh.user", memento.getString("ssh.user"));
        properties.put("encoding", memento.getString("encoding"));
        String password = null;
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (String)properties.get("ip.host") != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + (String)properties.get("ip.host"))) != null) {
            try {
                password = node.get("password", null);
            }
            catch (StorageException storageException) {
                // empty catch block
            }
        }
        properties.put("ssh.password", password);
    }
}

