/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.ssh.connector;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.connector.ssh.activator.UIPlugin;
import org.eclipse.tm.terminal.connector.ssh.connector.KeyboardInteractiveDialog;
import org.eclipse.tm.terminal.connector.ssh.connector.SshConnector;
import org.eclipse.tm.terminal.connector.ssh.connector.SshMessages;
import org.eclipse.tm.terminal.connector.ssh.connector.UserValidationDialog;

public class SshConnection
extends Thread {
    private static int fgNo;
    final ITerminalControl fControl;
    private final SshConnector fConn;
    private Session fSession;
    private boolean fDisconnectHasBeenCalled;

    protected SshConnection(SshConnector conn, ITerminalControl control) {
        super("SshConnection-" + fgNo++);
        this.fControl = control;
        this.fConn = conn;
        this.fControl.setState(TerminalState.CONNECTING);
    }

    protected Session createSession(String username, String password, String hostname, int port, UserInfo wrapperUI, IProgressMonitor monitor) throws JSchException {
        IJSchService service = UIPlugin.getDefault().getJSchService();
        if (service == null) {
            return null;
        }
        Session session = service.createSession(hostname, port, username);
        session.setTimeout(0);
        session.setServerAliveCountMax(6);
        if (password != null) {
            session.setPassword(password);
        }
        session.setUserInfo(wrapperUI);
        return session;
    }

    public static void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block41: {
            block40: {
                block39: {
                    block38: {
                        connectSucceeded = false;
                        host = "";
                        port = 22;
                        try {
                            nTimeout = this.fConn.getSshSettings().getTimeout() * 1000;
                            nKeepalive = this.fConn.getSshSettings().getKeepalive() * 1000;
                            host = this.fConn.getSshSettings().getHost();
                            user = this.fConn.getSshSettings().getUser();
                            password = this.fConn.getSshSettings().getPassword();
                            port = this.fConn.getSshSettings().getPort();
                            ui = new MyUserInfo(null, user, password);
                            session = this.createSession(user, password, host, port, ui, (IProgressMonitor)new NullProgressMonitor());
                            var10_12 = this;
                            synchronized (var10_12) {
                                this.fSession = session;
                            }
                            if (nKeepalive > 0) {
                                session.setServerAliveInterval(nKeepalive);
                            }
                            var10_12 = this;
                            synchronized (var10_12) {
                                if (this.fDisconnectHasBeenCalled) {
                                    break block38;
                                }
                                break block41;
                            }
                        }
                        catch (Exception e) {
                            cause /* !! */  = e;
                            break block39;
                        }
                    }
                    try {
                        this.disconnect();
                        return;
                    }
                    finally {
                        this.fControl.setState(TerminalState.CLOSED);
                    }
                }
                while (true) {
                    if (cause /* !! */ .getCause() == null) {
                        origMsg = cause /* !! */ .getMessage();
                        msg = SshMessages.getMessageFor(cause /* !! */ );
                        if (cause /* !! */  instanceof JSchException && origMsg != null && origMsg.startsWith("Auth")) {
                            if (origMsg.indexOf("cancel") < 0) break;
                            msg = SshMessages.SSH_AUTH_CANCEL;
                        }
                        break block40;
                    }
                    cause /* !! */  = cause /* !! */ .getCause();
                }
                if (origMsg.indexOf("fail") >= 0) {
                    msg = SshMessages.SSH_AUTH_FAIL;
                }
            }
            if (!connectSucceeded) {
                hostPort = host;
                if (port != 22) {
                    hostPort = (String)hostPort + ":" + port;
                }
                msg = NLS.bind((String)SshMessages.ERROR_CONNECTING, (Object)hostPort, (Object)msg);
            }
            this.connectFailed(msg, msg);
            return;
        }
        session.connect(nTimeout);
        if (this.isSessionConnected()) ** GOTO lbl-1000
        try {
            this.disconnect();
            return;
        }
        finally {
            this.fControl.setState(TerminalState.CLOSED);
        }
lbl-1000:
        // 1 sources

        {
            channel = (ChannelShell)session.openChannel("shell");
            channel.setPtyType("xterm");
            this.fControl.setVT100LineWrapping(true);
            channel.connect();
            if (this.isSessionConnected() == false) return;
            if (channel.isConnected() == false) return;
            connectSucceeded = true;
            this.fConn.setInputStream(channel.getInputStream());
            this.fConn.setOutputStream(channel.getOutputStream());
            this.fConn.setChannel(channel);
            this.fControl.setState(TerminalState.CONNECTED);
            try {
                this.readDataForever(this.fConn.getInputStream());
                return;
            }
            catch (InterruptedIOException var11_18) {
                return;
            }
        }
    }

    synchronized boolean isSessionConnected() {
        return !this.fDisconnectHasBeenCalled && this.fSession != null && this.fSession.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        this.interrupt();
        SshConnection sshConnection = this;
        synchronized (sshConnection) {
            this.fDisconnectHasBeenCalled = true;
            if (this.fSession != null) {
                try {
                    this.fSession.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.fSession = null;
            }
        }
    }

    private void readDataForever(InputStream in) throws IOException {
        int n;
        byte[] bytes = new byte[32768];
        while ((n = in.read(bytes)) != -1) {
            this.fControl.getRemoteToTerminalOutputStream().write(bytes, 0, n);
        }
    }

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void connectFailed(String terminalText, String msg) {
        Logger.log((String)terminalText);
        this.fControl.displayTextInTerminal(terminalText);
    }

    private class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        final String fConnectionId;
        final String fUser;
        private String fPassword;
        private String fPassphrase;
        private int fAttemptCount;

        public MyUserInfo(String connectionId, String user, String password) {
            this.fConnectionId = connectionId;
            this.fUser = user;
            this.fPassword = password;
        }

        public String getPassword() {
            return this.fPassword;
        }

        public boolean promptYesNo(final String str) {
            final boolean[] retval = new boolean[1];
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SshConnection.this.isSessionConnected()) {
                        MessageBox mb = new MessageBox(((MyUserInfo)MyUserInfo.this).SshConnection.this.fControl.getShell(), 196);
                        mb.setText(SshMessages.WARNING);
                        mb.setMessage(str);
                        retval[0] = mb.open() == 64;
                    } else {
                        retval[0] = false;
                    }
                }
            });
            return retval[0];
        }

        private String promptSecret(final String message) {
            final String[] retval = new String[1];
            SshConnection.getStandardDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SshConnection.this.isSessionConnected()) {
                        UserValidationDialog uvd = new UserValidationDialog(null, MyUserInfo.this.fConnectionId, MyUserInfo.this.fUser, message);
                        uvd.setUsernameMutable(false);
                        retval[0] = uvd.open() == 0 ? uvd.getPassword() : null;
                    } else {
                        retval[0] = null;
                    }
                }
            });
            return retval[0];
        }

        public String getPassphrase() {
            return this.fPassphrase;
        }

        public boolean promptPassphrase(String message) {
            this.fPassphrase = this.promptSecret(message);
            return this.fPassphrase != null;
        }

        public boolean promptPassword(String message) {
            String _password = this.promptSecret(message);
            if (_password != null) {
                this.fPassword = _password;
                return true;
            }
            return false;
        }

        public void showMessage(final String message) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SshConnection.this.isSessionConnected()) {
                        MessageBox mb = new MessageBox(((MyUserInfo)MyUserInfo.this).SshConnection.this.fControl.getShell(), 34);
                        mb.setText(SshMessages.INFO);
                        mb.setMessage(message);
                        mb.open();
                    }
                }
            });
        }

        public String[] promptKeyboardInteractive(final String destination, final String name, final String instruction, final String[] prompt, final boolean[] echo) {
            String[] result;
            block6: {
                if (prompt.length == 0) {
                    return new String[0];
                }
                try {
                    if (this.fAttemptCount == 0 && this.fPassword != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                        ++this.fAttemptCount;
                        return new String[]{this.fPassword};
                    }
                    final String[][] finResult = new String[1][];
                    SshConnection.getStandardDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SshConnection.this.isSessionConnected()) {
                                KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, MyUserInfo.this.fConnectionId, destination, name, instruction, prompt, echo);
                                dialog.open();
                                finResult[0] = dialog.getResult();
                            } else {
                                finResult[0] = null;
                            }
                        }
                    });
                    result = finResult[0];
                    if (result != null) break block6;
                    return null;
                }
                catch (OperationCanceledException e) {
                    return null;
                }
            }
            if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.fPassword = result[0];
            }
            ++this.fAttemptCount;
            return result;
        }
    }
}

