/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.cdtserial.connector;

import org.eclipse.cdt.serial.BaudRate;
import org.eclipse.cdt.serial.ByteSize;
import org.eclipse.cdt.serial.Parity;
import org.eclipse.cdt.serial.StandardBaudRates;
import org.eclipse.cdt.serial.StopBits;
import org.eclipse.terminal.connector.ISettingsStore;

public class SerialSettings {
    public static final String PORT_NAME_ATTR = "cdtserial.portName";
    public static final String BAUD_RATE_ATTR = "cdtserial.baudRate";
    public static final String BYTE_SIZE_ATTR = "cdtserial.byteSize";
    public static final String PARITY_ATTR = "cdtserial.parity";
    public static final String STOP_BITS_ATTR = "cdtserial.stopBits";
    private String portName;
    private int baudRate;
    private ByteSize byteSize;
    private Parity parity;
    private StopBits stopBits;

    public void load(ISettingsStore store) {
        String byteSizeStr;
        this.portName = store.get(PORT_NAME_ATTR, "");
        String baudRateStr = store.get(BAUD_RATE_ATTR, "");
        this.baudRate = 0;
        try {
            this.baudRate = Integer.parseInt(baudRateStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.baudRate <= 0) {
            this.baudRate = StandardBaudRates.getDefault();
        }
        if ((byteSizeStr = store.get(BYTE_SIZE_ATTR, "")).isEmpty()) {
            this.byteSize = ByteSize.getDefault();
        } else {
            String[] sizes = ByteSize.getStrings();
            int i = 0;
            while (i < sizes.length) {
                if (byteSizeStr.equals(sizes[i])) {
                    this.byteSize = ByteSize.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
        String parityStr = store.get(PARITY_ATTR, "");
        if (parityStr.isEmpty()) {
            this.parity = Parity.getDefault();
        } else {
            String[] parities = Parity.getStrings();
            int i = 0;
            while (i < parities.length) {
                if (parityStr.equals(parities[i])) {
                    this.parity = Parity.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
        String stopBitsStr = store.get(STOP_BITS_ATTR, "");
        if (stopBitsStr.isEmpty()) {
            this.stopBits = StopBits.getDefault();
        } else {
            String[] bits = StopBits.getStrings();
            int i = 0;
            while (i < bits.length) {
                if (stopBitsStr.equals(bits[i])) {
                    this.stopBits = StopBits.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
    }

    public void save(ISettingsStore store) {
        store.put(PORT_NAME_ATTR, this.portName);
        store.put(BAUD_RATE_ATTR, Integer.toString(this.baudRate));
        store.put(BYTE_SIZE_ATTR, ByteSize.getStrings()[ByteSize.getStringIndex((ByteSize)this.byteSize)]);
        store.put(PARITY_ATTR, Parity.getStrings()[Parity.getStringIndex((Parity)this.parity)]);
        store.put(STOP_BITS_ATTR, StopBits.getStrings()[StopBits.getStringIndex((StopBits)this.stopBits)]);
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public int getBaudRateValue() {
        return this.baudRate;
    }

    @Deprecated
    public void setBaudRate(BaudRate baudRate) {
        this.baudRate = baudRate.getRate();
    }

    public void setBaudRateValue(int baudRate) {
        this.baudRate = baudRate;
    }

    public ByteSize getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(ByteSize byteSize) {
        this.byteSize = byteSize;
    }

    public Parity getParity() {
        return this.parity;
    }

    public void setParity(Parity parity) {
        this.parity = parity;
    }

    public StopBits getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(StopBits stopBits) {
        this.stopBits = stopBits;
    }

    public String getSummary() {
        return this.portName;
    }
}

