/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetConfiguration;
import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfigurationManager;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

abstract class AbstractWorkingSetsContribution
extends CompoundContributionItem {
    private IWorkingSetManager workingSetManager;

    public AbstractWorkingSetsContribution() {
    }

    public AbstractWorkingSetsContribution(String id) {
        super(id);
    }

    protected IContributionItem[] getContributionItems() {
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>(5);
        int i = 0;
        IWorkingSet[] iWorkingSetArray = this.getWorkingsetManager().getRecentWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item;
            IWorkingSet recent = iWorkingSetArray[n2];
            IWorkingSetProxy proxy = WorkingSetConfigurationManager.getDefault().getWorkingSet(recent.getName());
            if (proxy != null && (item = this.createMenu(proxy, i++)) != null) {
                result.add(item);
            }
            ++n2;
        }
        return result.toArray(new IContributionItem[result.size()]);
    }

    private IWorkingSetManager getWorkingsetManager() {
        if (this.workingSetManager == null) {
            this.workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        }
        return this.workingSetManager;
    }

    private IContributionItem createMenu(IWorkingSetProxy workingSet, int index) {
        MenuManager result = null;
        IWorkingSet ws = workingSet.resolve();
        String label = NLS.bind((String)WorkingSetMessages.WorkingSetMenus_enumPattern, (Object)(index + 1), (Object)ws.getLabel());
        Collection<IWorkingSetConfiguration> configs = workingSet.getConfigurations();
        if (!configs.isEmpty()) {
            MenuManager submenu;
            result = submenu = new MenuManager(label, ws.getName());
            submenu.add(this.createContribution(workingSet));
        }
        return result;
    }

    protected abstract IContributionItem createContribution(IWorkingSetProxy var1);
}

