/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class LineComparator
implements IRangeComparator {
    private static final long UNKNOWN_HASH = Long.MIN_VALUE;
    private final IDocument fDocument;
    private final long[] fHashes;

    public LineComparator(IDocument document) {
        this.fDocument = document;
        this.fHashes = new long[this.fDocument.getNumberOfLines()];
        int i = 0;
        while (i < this.fHashes.length) {
            this.fHashes[i] = Long.MIN_VALUE;
            ++i;
        }
    }

    public int getRangeCount() {
        return this.fDocument.getNumberOfLines();
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        try {
            return this.getHash(thisIndex) == ((LineComparator)other).getHash(otherIndex);
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
            return false;
        }
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }

    private int getHash(int line) throws BadLocationException {
        long hash = this.fHashes[line];
        if (hash == Long.MIN_VALUE) {
            IRegion lineRegion = this.fDocument.getLineInformation(line);
            String lineContents = this.fDocument.get(lineRegion.getOffset(), lineRegion.getLength());
            this.fHashes[line] = hash = (long)this.computeDJBHash(lineContents);
        }
        return (int)hash;
    }

    private int computeDJBHash(String string) {
        int hash = 5381;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char ch = string.charAt(i);
            hash = (hash << 5) + hash + ch;
            ++i;
        }
        return hash;
    }
}

