/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.gettersandsetters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.AccessorDescriptor;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterContext;
import org.eclipse.cdt.internal.ui.refactoring.gettersandsetters.GetterSetterNameGenerator;

class FieldDescriptor {
    private final IASTName fieldName;
    private final IASTDeclarator fieldDeclarator;
    private final AccessorDescriptor getter;
    private final AccessorDescriptor setter;
    private final AccessorDescriptor[] childNodes;
    private final GetterSetterContext context;

    FieldDescriptor(IASTDeclarator field, GetterSetterContext context) {
        this.fieldName = GetterSetterContext.getDeclaratorName(field);
        this.fieldDeclarator = field;
        this.context = context;
        Set<String> namesToAvoid = this.getNamesToAvoid();
        String name = GetterSetterNameGenerator.generateGetterName(this.fieldName, namesToAvoid);
        this.getter = new AccessorDescriptor(AccessorDescriptor.AccessorKind.GETTER, name, this);
        name = GetterSetterNameGenerator.generateSetterName(this.fieldName, namesToAvoid);
        if (!FieldDescriptor.isAssignable(field)) {
            name = null;
        }
        this.setter = new AccessorDescriptor(AccessorDescriptor.AccessorKind.SETTER, name, this);
        ArrayList<AccessorDescriptor> children = new ArrayList<AccessorDescriptor>(2);
        if (this.getter.canBeGenerated()) {
            children.add(this.getter);
        }
        if (this.setter.canBeGenerated()) {
            children.add(this.setter);
        }
        this.childNodes = children.toArray(new AccessorDescriptor[children.size()]);
    }

    private Set<String> getNamesToAvoid() {
        HashSet<String> namesToAvoid = new HashSet<String>();
        for (IASTDeclarator fieldDeclarator : this.context.existingFields) {
            namesToAvoid.add(String.valueOf(GetterSetterContext.getDeclaratorName(fieldDeclarator).getSimpleID()));
        }
        if (!this.context.existingFields.isEmpty()) {
            IASTNode node = this.context.existingFields.get(0).getParent();
            while (!(node instanceof IASTCompositeTypeSpecifier)) {
                node = node.getParent();
            }
            IASTCompositeTypeSpecifier comp = (IASTCompositeTypeSpecifier)node;
            namesToAvoid.add(String.valueOf(comp.getName().getLastName().getSimpleID()));
        }
        return namesToAvoid;
    }

    private static boolean isAssignable(IASTDeclarator fieldDeclarator) {
        IASTName name = GetterSetterContext.getDeclaratorName(fieldDeclarator);
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof ICPPField)) {
            return false;
        }
        ICPPField field = (ICPPField)binding;
        IType type = field.getType();
        if ((type = SemanticUtil.getNestedType((IType)type, (int)1)) instanceof IArrayType || type instanceof ICPPReferenceType) {
            return false;
        }
        if (type instanceof IPointerType && ((IPointerType)type).isConst()) {
            return false;
        }
        return !(type instanceof IQualifierType) || !((IQualifierType)type).isConst();
    }

    public String toString() {
        return this.fieldName.toString();
    }

    AccessorDescriptor[] getChildNodes() {
        return this.childNodes;
    }

    boolean missingGetterOrSetter() {
        return this.getter.canBeGenerated() || this.setter.canBeGenerated();
    }

    public GetterSetterContext getContext() {
        return this.context;
    }

    public IASTName getFieldName() {
        return this.fieldName;
    }

    public IASTDeclarator getFieldDeclarator() {
        return this.fieldDeclarator;
    }

    public AccessorDescriptor getGetter() {
        return this.getter;
    }

    public AccessorDescriptor getSetter() {
        return this.setter;
    }
}

