/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.ui.refactoring.changes.CCompositeChange;
import org.eclipse.cdt.internal.ui.refactoring.changes.CreateFileChange;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

public class ModificationCollector {
    private final IResourceChangeDescriptionFactory deltaFactory;
    private final Map<IASTTranslationUnit, ASTRewrite> rewriters = new HashMap<IASTTranslationUnit, ASTRewrite>();
    private Collection<CreateFileChange> changes;

    public ModificationCollector() {
        this(null);
    }

    public ModificationCollector(IResourceChangeDescriptionFactory deltaFactory) {
        this.deltaFactory = deltaFactory;
    }

    public ASTRewrite rewriterForTranslationUnit(IASTTranslationUnit ast) {
        if (!this.rewriters.containsKey(ast)) {
            this.rewriters.put(ast, ASTRewrite.create((IASTTranslationUnit)ast));
            if (this.deltaFactory != null) {
                this.deltaFactory.change((IFile)ast.getOriginatingTranslationUnit().getResource());
            }
        }
        return this.rewriters.get(ast);
    }

    public void addFileChange(CreateFileChange change) {
        if (this.changes == null) {
            this.changes = new ArrayList<CreateFileChange>();
        }
        this.changes.add(change);
        if (this.deltaFactory != null) {
            this.deltaFactory.create(change.getModifiedResource());
        }
    }

    public CCompositeChange createFinalChange() {
        CCompositeChange result = new CCompositeChange("");
        result.markAsSynthetic();
        if (this.changes != null) {
            for (Change change : this.changes) {
                this.addFlattened(change, result);
            }
        }
        for (ASTRewrite aSTRewrite : this.rewriters.values()) {
            Change change = aSTRewrite.rewriteAST();
            this.addFlattened(change, result);
        }
        return result;
    }

    private void addFlattened(Change change, CompositeChange receiver) {
        if (change instanceof CompositeChange) {
            receiver.merge((CompositeChange)change);
        } else {
            receiver.add(change);
        }
    }
}

