/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIGDBShowLanguageInfo
extends MIInfo {
    public static final String LOCAL = "local";
    public static final String AUTO = "auto";
    public static final String ADA = "ada";
    public static final String C = "c";
    public static final String C_PLUS_PLUS = "c++";
    public static final String ASM = "asm";
    public static final String MINIMAL = "minimal";
    public static final String D = "d";
    public static final String FORTRAN = "fortran";
    public static final String OBJECTIVE_C = "objective-c";
    public static final String GO = "go";
    public static final String JAVA = "java";
    public static final String MODULA_2 = "modula-2";
    public static final String OPENCL = "opencl";
    public static final String PASCAL = "pascal";
    private String fLanguage = "auto";

    public MIGDBShowLanguageInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    protected void parse() {
        MIOutput out;
        MIResultRecord outr;
        if (this.isDone() && (outr = (out = this.getMIOutput()).getMIResultRecord()) != null) {
            MIResult[] results = outr.getMIResults();
            int i = 0;
            while (i < results.length) {
                MIValue value;
                String var = results[i].getVariable();
                if (var.equals("value") && (value = results[i].getMIValue()) instanceof MIConst) {
                    this.fLanguage = ((MIConst)value).getString();
                    int semiColonIdx = this.fLanguage.indexOf(59);
                    if (semiColonIdx != -1) {
                        this.fLanguage = this.fLanguage.substring(0, semiColonIdx);
                    }
                }
                ++i;
            }
        }
    }

    public String getLanguage() {
        return this.fLanguage;
    }
}

