/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.llvm.dsf.lldb.ui.internal;

import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LocalApplicationCDebuggerTab;
import org.eclipse.cdt.llvm.dsf.lldb.ui.internal.LLDBCDebuggerPage;
import org.eclipse.cdt.llvm.dsf.lldb.ui.internal.LLDBUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class LLDBLocalApplicationCDebuggerTab
extends LocalApplicationCDebuggerTab {
    private static final String LOCAL_DEBUGGER_ID = "lldb-mi";
    private static final String DEFAULTS_SET = "org.eclipse.cdt.llvm.dsf.lldb.ui.internal.LLDBLocalApplicationCDebuggerTab.DEFAULTS_SET";

    protected void initDebuggerTypes(String selection) {
        if (this.fAttachMode) {
            this.setInitializeDefault(selection.isEmpty());
            if (selection.isEmpty()) {
                selection = LOCAL_DEBUGGER_ID;
            }
            this.loadDebuggerCombo(new String[]{LOCAL_DEBUGGER_ID}, selection);
        } else {
            this.setDebuggerId(LOCAL_DEBUGGER_ID);
            this.updateComboFromSelection();
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            if (!config.hasAttribute(DEFAULTS_SET)) {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                this.setDefaults(wc);
                wc.doSave();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        super.initializeFrom(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        IPreferenceStore corePreferenceStore = LLDBUIPlugin.getDefault().getCorePreferenceStore();
        config.setAttribute("org.eclipse.cdt.llvm.dsf.lldb.core.DEBUG_NAME", corePreferenceStore.getString("defaultLLDBCommand"));
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", corePreferenceStore.getBoolean("defaultStopAtMain"));
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", corePreferenceStore.getString("defaultStopAtMainSymbol"));
        config.setAttribute(DEFAULTS_SET, true);
    }

    protected void loadDynamicDebugArea() {
        Composite dynamicTabHolder = this.getDynamicTabHolder();
        Control[] children = dynamicTabHolder.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        String debuggerId = this.getIdForCurrentDebugger();
        if (debuggerId == null) {
            this.setDynamicTab(null);
        } else if (debuggerId.equals(LOCAL_DEBUGGER_ID)) {
            this.setDynamicTab((ICDebuggerPage)new LLDBCDebuggerPage());
        } else assert (false) : "Unknown debugger id";
        this.setDebuggerId(debuggerId);
        ICDebuggerPage debuggerPage = this.getDynamicTab();
        if (debuggerPage == null) {
            return;
        }
        debuggerPage.setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        debuggerPage.createControl(dynamicTabHolder);
        debuggerPage.getControl().setVisible(true);
        dynamicTabHolder.layout(true);
        this.contentsChanged();
    }
}

