/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.llvm.dsf.lldb.ui.internal;

import java.io.File;
import org.eclipse.cdt.dsf.debug.internal.ui.preferences.StringWithBooleanFieldEditor;
import org.eclipse.cdt.llvm.dsf.lldb.ui.internal.LLDBUIPlugin;
import org.eclipse.cdt.llvm.dsf.lldb.ui.internal.Messages;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class LLDBDebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StringFieldEditor fStringFieldEditorCommand;
    private StringWithBooleanFieldEditor fEnableStopAtMain;

    public LLDBDebugPreferencePage() {
        super(0);
        IPreferenceStore store = LLDBUIPlugin.getDefault().getCorePreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(Messages.LLDBDebugPreferencePage_description);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Group group1 = new Group(parent, 0);
        group1.setText(Messages.LLDBDebugPreferencePage_defaults_label);
        GridLayout groupLayout = new GridLayout(3, false);
        group1.setLayout((Layout)groupLayout);
        group1.setLayoutData((Object)new GridData(768));
        this.fStringFieldEditorCommand = new StringFieldEditor("defaultLLDBCommand", Messages.LLDBCDebuggerPage_debugger_command, (Composite)group1);
        this.fStringFieldEditorCommand.fillIntoGrid((Composite)group1, 2);
        GridData stringFieldLayoutData = (GridData)this.fStringFieldEditorCommand.getTextControl((Composite)group1).getLayoutData();
        stringFieldLayoutData.widthHint = 300;
        this.addField((FieldEditor)this.fStringFieldEditorCommand);
        Button browsebutton = new Button((Composite)group1, 8);
        browsebutton.setText(Messages.LLDBCDebuggerPage_browse);
        browsebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LLDBDebugPreferencePage.this.handleBrowseButtonSelected(Messages.LLDBCDebuggerPage_browse_dialog_title, LLDBDebugPreferencePage.this.fStringFieldEditorCommand);
            }
        });
        this.setButtonLayoutData(browsebutton);
        this.fEnableStopAtMain = LLDBDebugPreferencePage.createStopAtMainEditor(group1);
        this.fEnableStopAtMain.fillIntoGrid((Composite)group1, 3);
        this.addField((FieldEditor)this.fEnableStopAtMain);
        group1.setLayout((Layout)groupLayout);
        this.createLinkToGdb(parent);
    }

    private static StringWithBooleanFieldEditor createStopAtMainEditor(Group group1) {
        return new StringWithBooleanFieldEditor("defaultStopAtMain", "defaultStopAtMainSymbol", Messages.LLDBDebugPreferencePage_Stop_on_startup_at, (Composite)group1);
    }

    private Control createLinkToGdb(Composite parent) {
        String text = Messages.LLDBDebugPreferencePage_see_gdb_preferences;
        Link link = new Link(parent, 0);
        link.setText(text);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)LLDBDebugPreferencePage.this.getShell(), (String)event.text, null, null);
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 150;
        link.setLayoutData((Object)gridData);
        return link;
    }

    private void handleBrowseButtonSelected(String dialogTitle, StringFieldEditor stringFieldEditor) {
        String res;
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(dialogTitle);
        String lldbCommand = stringFieldEditor.getStringValue().trim();
        int lastSeparatorIndex = lldbCommand.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(lldbCommand.substring(0, lastSeparatorIndex));
        }
        if ((res = dialog.open()) == null) {
            return;
        }
        stringFieldEditor.setStringValue(res);
    }

    protected void adjustGridLayout() {
    }
}

