/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.examples.dsf.timers;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.examples.dsf.timers.AlarmService;
import org.eclipse.cdt.examples.dsf.timers.AlarmsVMNode;
import org.eclipse.cdt.examples.dsf.timers.TimerService;
import org.eclipse.cdt.examples.dsf.timers.TimersRootVMNode;
import org.eclipse.cdt.examples.dsf.timers.TimersVMNode;
import org.eclipse.cdt.examples.dsf.timers.TimersViewColumnPresentation;
import org.eclipse.cdt.examples.dsf.timers.TriggersVMNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class TimersVMProvider
extends AbstractDMVMProvider {
    private boolean fRegisteredEventListener;

    public TimersVMProvider(AbstractVMAdapter adapter, IPresentationContext presentationContext, DsfSession session) {
        super(adapter, presentationContext, session);
        try {
            session.getExecutor().execute(() -> {
                if (DsfSession.isSessionActive((String)this.getSession().getId())) {
                    this.getSession().addServiceEventListener((Object)this, null);
                    this.fRegisteredEventListener = true;
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.setViewLayout(ViewLayout.TIMERS_AT_TOP);
    }

    public void dispose() {
        try {
            this.getSession().getExecutor().execute(() -> {
                if (this.fRegisteredEventListener && DsfSession.isSessionActive((String)this.getSession().getId())) {
                    this.getSession().removeServiceEventListener((Object)this);
                    this.fRegisteredEventListener = false;
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        super.dispose();
    }

    public void setViewLayout(ViewLayout layout) {
        this.clearNodes();
        if (layout == ViewLayout.TRIGGERS_AT_TOP) {
            TimersRootVMNode root = new TimersRootVMNode((AbstractVMProvider)this);
            TriggersVMNode triggersNode = new TriggersVMNode(this, this.getSession());
            this.addChildNodes((IVMNode)root, new IVMNode[]{triggersNode});
            TimersVMNode timersNode = new TimersVMNode(this, this.getSession());
            this.addChildNodes((IVMNode)triggersNode, new IVMNode[]{timersNode});
            AlarmsVMNode alarmNode = new AlarmsVMNode(this, this.getSession());
            this.addChildNodes((IVMNode)timersNode, new IVMNode[]{alarmNode});
            this.setRootNode((IRootVMNode)root);
        } else if (layout == ViewLayout.TIMERS_AT_TOP) {
            TimersRootVMNode root = new TimersRootVMNode((AbstractVMProvider)this);
            TimersVMNode timersNode = new TimersVMNode(this, this.getSession());
            this.addChildNodes((IVMNode)root, new IVMNode[]{timersNode});
            TriggersVMNode triggersNode = new TriggersVMNode(this, this.getSession());
            this.addChildNodes((IVMNode)timersNode, new IVMNode[]{triggersNode});
            AlarmsVMNode alarmNode = new AlarmsVMNode(this, this.getSession());
            this.addChildNodes((IVMNode)triggersNode, new IVMNode[]{alarmNode});
            this.setRootNode((IRootVMNode)root);
        }
        this.handleEvent(new TimersViewLayoutChanged());
    }

    public IColumnPresentation createColumnPresentation(IPresentationContext context, Object element) {
        return new TimersViewColumnPresentation();
    }

    public String getColumnPresentationId(IPresentationContext context, Object element) {
        return "org.eclipse.cdt.examples.dsf.TIMER_COLUMN_PRESENTATION_ID";
    }

    @DsfServiceEventHandler
    public void eventDispatched(AlarmService.TriggersChangedEvent event) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.handleEvent(event);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(TimerService.TimersChangedEvent event) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.getExecutor().execute(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.handleEvent(event);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public static class TimersViewLayoutChanged {
    }

    public static enum ViewLayout {
        TRIGGERS_AT_TOP,
        TIMERS_AT_TOP;

    }
}

