/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.File;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICDescriptionDelta;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.util.ResourceChangeHandlerBase;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IConfigurationBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IProjectBuildState;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.ProjectBuildState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class BuildStateManager {
    private static final String PREFS_LOCATION = "buildState";
    private static BuildStateManager fInstance;
    private EventListener fListener;

    private void removeProjectInfo(IProject project) {
        File f = this.getPrefsDir(project);
        if (f.exists()) {
            File[] children = f.listFiles();
            int i = 0;
            while (i < children.length) {
                children[i].delete();
                ++i;
            }
            f.delete();
        }
    }

    private BuildStateManager() {
    }

    public static BuildStateManager getInstance() {
        if (fInstance == null) {
            fInstance = new BuildStateManager();
        }
        return fInstance;
    }

    public void startup() {
        if (this.fListener == null) {
            this.fListener = new EventListener();
            CoreModel.getDefault().getProjectDescriptionManager().addCProjectDescriptionListener((ICProjectDescriptionListener)this.fListener, 5);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fListener, 7);
        }
    }

    public void shutdown() {
        if (this.fListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fListener);
            CoreModel.getDefault().getProjectDescriptionManager().removeCProjectDescriptionListener((ICProjectDescriptionListener)this.fListener);
        }
    }

    public IProjectBuildState getProjectBuildState(IProject project) {
        return new ProjectBuildState(project);
    }

    public void setProjectBuildState(IProject project, IProjectBuildState state) {
        ((ProjectBuildState)state).serialize();
    }

    private IPath getPrefsDirPath() {
        IPath path = ManagedBuilderCorePlugin.getDefault().getStateLocation();
        path = path.append(PREFS_LOCATION);
        return path;
    }

    IPath getPrefsDirPath(IProject project) {
        IPath path = this.getPrefsDirPath();
        path = path.append(project.getName());
        return path;
    }

    private File getPrefsDir(IProject project) {
        IPath path = this.getPrefsDirPath(project);
        File file = path.toFile();
        return file;
    }

    private class EventListener
    extends ResourceChangeHandlerBase
    implements ICProjectDescriptionListener {
        private EventListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            super.resourceChanged(event);
        }

        public void handleEvent(CProjectDescriptionEvent event) {
            switch (event.getEventType()) {
                case 1: 
                case 4: {
                    ICDescriptionDelta delta = event.getProjectDelta();
                    this.processAppliedDelta(event, delta);
                }
            }
        }

        private void processAppliedDelta(CProjectDescriptionEvent event, ICDescriptionDelta delta) {
            if (delta == null) {
                return;
            }
            IProjectBuildState pbs = null;
            boolean apply = false;
            switch (delta.getDeltaKind()) {
                case 1: {
                    BuildStateManager.this.removeProjectInfo(event.getProject());
                    break;
                }
                case 3: {
                    ICDescriptionDelta[] children = delta.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        String id;
                        IConfigurationBuildState cbs;
                        if (children[i].getDeltaKind() == 1 && pbs == null && (cbs = (pbs = BuildStateManager.this.getProjectBuildState(event.getProject())).getConfigurationBuildState(id = children[i].getSetting().getId(), false)) != null) {
                            apply = true;
                            pbs.removeConfigurationBuildState(id);
                        }
                        ++i;
                    }
                    break;
                }
            }
            if (pbs != null && apply) {
                BuildStateManager.this.setProjectBuildState(event.getProject(), pbs);
            }
        }

        protected ResourceChangeHandlerBase.IResourceMoveHandler createResourceMoveHandler(IResourceChangeEvent event) {
            return new ResourceMoveHandler();
        }
    }

    private class ResourceMoveHandler
    implements ResourceChangeHandlerBase.IResourceMoveHandler {
        private ResourceMoveHandler() {
        }

        public void done() {
        }

        public void handleProjectClose(IProject project) {
        }

        public boolean handleResourceMove(IResource fromRc, IResource toRc) {
            return this.doHandleResourceRemove(fromRc);
        }

        public boolean handleResourceRemove(IResource rc) {
            return this.doHandleResourceRemove(rc);
        }

        private boolean doHandleResourceRemove(IResource rc) {
            switch (rc.getType()) {
                case 4: {
                    BuildStateManager.this.removeProjectInfo(rc.getProject());
                    return false;
                }
                case 8: {
                    return true;
                }
            }
            return false;
        }
    }
}

