/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.proxy.protocol.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;

public class StreamChannelManager
implements Runnable {
    private static final int CMD_OPEN = 161;
    private static final int CMD_CLOSE = 162;
    private static final int CMD_CLOSEACK = 163;
    private static final int CMD_REQUEST = 164;
    private static final int CMD_TRANSMIT = 165;
    private static final int CMD_CLOSE_INPUT = 166;
    private static final int CMD_CLOSE_OUTPUT = 167;
    private static final int SERVER_ID_MASK = 32768;
    private static final int MAX_CHANNELS = 16384;
    private final Map<Integer, StreamChannel> channels = Collections.synchronizedMap(new HashMap());
    private final List<IChannelListener> listeners = Collections.synchronizedList(new ArrayList());
    private Set<Short> usedIds = new HashSet<Short>();
    private int nextUnusedChannelId;
    private boolean isServer;
    private volatile boolean running = true;
    private Sender sender;
    private Receiver receiver;
    private boolean debug = false;

    private boolean isMyChannel(int id) {
        return !(this.isServer ^ (id & 0x8000) == 32768);
    }

    public StreamChannelManager(InputStream in, OutputStream out) {
        this.sender = new Sender(new BufferedOutputStream(out));
        this.receiver = new Receiver(new BufferedInputStream(in));
    }

    synchronized int newId() throws IOException {
        if (!this.usedIds.isEmpty()) {
            Short id = this.usedIds.iterator().next();
            this.usedIds.remove(id);
            this.debugPrint("recover id=" + String.valueOf(id));
            return id.shortValue();
        }
        int nextId = this.nextUnusedChannelId;
        if (this.nextUnusedChannelId++ > 16383) {
            throw new IOException("Maximum number of channels exceeded");
        }
        return nextId | (this.isServer ? 32768 : 0);
    }

    synchronized void freeId(int id) {
        this.debugPrint("free id=" + id);
        this.usedIds.add((short)id);
    }

    void dump_buf(String pref, byte[] b, int off, int len) {
        System.err.print(pref + ": ");
        int i = off;
        while (i < len + off) {
            if (b[i] <= 32 || b[i] > 126) {
                System.err.print(String.format(" 0x%02x ", b[i]));
            } else {
                System.err.print((char)b[i]);
            }
            ++i;
        }
        System.err.println();
    }

    public boolean isServer() {
        return this.isServer;
    }

    public void setServer(boolean server) {
        this.isServer = server;
    }

    public void addListener(IChannelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IChannelListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    protected void newChannelCallback(StreamChannel chan) {
        IChannelListener[] iChannelListenerArray = this.listeners.toArray(new IChannelListener[this.listeners.size()]);
        int n = iChannelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IChannelListener listener = iChannelListenerArray[n2];
            listener.newChannel(chan);
            ++n2;
        }
    }

    protected void closeChannelCallback(StreamChannel chan) {
        IChannelListener[] iChannelListenerArray = this.listeners.toArray(new IChannelListener[this.listeners.size()]);
        int n = iChannelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IChannelListener listener = iChannelListenerArray[n2];
            listener.closeChannel(chan);
            ++n2;
        }
    }

    public String dump_byte(byte b) {
        if (b <= 32 || b > 126) {
            return String.format(" 0x%02x ", b);
        }
        return String.valueOf((char)b);
    }

    public StreamChannel openChannel() throws IOException {
        if (!this.running) {
            throw new IOException("Multiplexer is not running");
        }
        StreamChannel chan = new StreamChannel(this, this.newId());
        this.channels.put(chan.getId(), chan);
        this.debugPrint("send cmd=OPEN id=" + chan.getId());
        this.sender.sendOpenCmd(chan.getId());
        return chan;
    }

    synchronized void sendTransmitCmd(StreamChannel chan, byte[] buf, int off, int len) throws IOException {
        if (this.running && chan.isOpen()) {
            this.debugPrint("send cmd=TRANSMIT id=" + chan.getId() + " len=" + len + " off=" + off + " buflen=" + buf.length);
            this.sender.sendTransmitCmd(chan.getId(), buf, off, len);
        }
    }

    synchronized void sendCloseCmd(StreamChannel chan) throws IOException {
        if (this.running && chan.isOpen()) {
            this.debugPrint("send cmd=CLOSE id=" + chan.getId());
            chan.disconnect();
            this.sender.sendCloseCmd(chan.getId());
            chan.setClosed();
        }
    }

    synchronized void sendCloseAckCmd(StreamChannel chan) throws IOException {
        if (this.running && chan.isOpen()) {
            this.debugPrint("send cmd=CLOSEACK id=" + chan.getId());
            this.sender.sendCloseAckCmd(chan.getId());
            chan.setClosed();
        }
    }

    synchronized void sendRequestCmd(StreamChannel chan, int len) throws IOException {
        if (this.running && chan.isOpen()) {
            this.debugPrint("send cmd=REQUEST id=" + chan.getId() + " len=" + len);
            this.sender.sendRequestCmd(chan.getId(), len);
        }
    }

    synchronized void sendCloseInputCmd(StreamChannel chan) throws IOException {
        if (this.running && chan.isOpen()) {
            if (!chan.isOutputConnected()) {
                this.sendCloseCmd(chan);
            } else {
                this.debugPrint("send cmd=CLOSE_INPUT id=" + chan.getId());
                this.sender.sendCloseInputCmd(chan.getId());
            }
        }
    }

    synchronized void sendCloseOutputCmd(StreamChannel chan) throws IOException {
        if (this.running && chan.isOpen()) {
            if (!chan.isInputConnected()) {
                this.sendCloseCmd(chan);
            } else {
                this.debugPrint("send cmd=CLOSE_OUTPUT id=" + chan.getId());
                this.sender.sendCloseOutputCmd(chan.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugPrint(String x) {
        if (this.debug) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println(x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.running) {
            return;
        }
        this.running = false;
        Map<Integer, StreamChannel> map = this.channels;
        synchronized (map) {
            for (StreamChannel c : this.channels.values()) {
                c.disconnect();
            }
        }
        this.channels.clear();
        this.sender.shutdown();
        this.receiver.shutdown();
        this.debugPrint("chan mpx stopped");
    }

    private String asString(int v) {
        switch (v) {
            case 161: {
                return "OPEN";
            }
            case 162: {
                return "CLOSE";
            }
            case 163: {
                return "CLOSEACK";
            }
            case 165: {
                return "TRANSMIT";
            }
            case 164: {
                return "REQUEST";
            }
        }
        return "<UNKNOWN>";
    }

    @Override
    public void run() {
        this.debugPrint("mux starting");
        new Thread((Runnable)this.sender, "mux sender").start();
        this.receiver.run();
    }

    public static interface IChannelListener {
        public void newChannel(StreamChannel var1);

        public void closeChannel(StreamChannel var1);
    }

    private class Receiver
    implements Runnable {
        private DataInputStream dataIn;

        public Receiver(InputStream in) {
            this.dataIn = new DataInputStream(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StreamChannelManager.this.running = true;
            try {
                int id;
                int cmd;
                block21: while (true) {
                    StreamChannelManager.this.debugPrint("start read");
                    cmd = this.dataIn.readByte() & 0xFF;
                    id = this.dataIn.readByte() & 0xFF;
                    switch (cmd) {
                        case 161: {
                            StreamChannelManager.this.debugPrint("received cmd=OPEN id=" + id);
                            StreamChannel chan = StreamChannelManager.this.channels.get(id);
                            if (chan != null) {
                                throw new IOException("Channel already exists");
                            }
                            if (!StreamChannelManager.this.isServer && (id & 0x8000) != 32768) {
                                throw new IOException("Client received invalid server channel id: " + id);
                            }
                            if (StreamChannelManager.this.isServer && (id & 0x8000) == 32768) {
                                throw new IOException("Server received invalid client channel id: " + id);
                            }
                            chan = new StreamChannel(StreamChannelManager.this, id);
                            StreamChannelManager.this.channels.put(id, chan);
                            StreamChannelManager.this.newChannelCallback(chan);
                            continue block21;
                        }
                        case 162: {
                            StreamChannelManager.this.debugPrint("received cmd=CLOSE id=" + id);
                            StreamChannel chan = StreamChannelManager.this.channels.get(id);
                            if (chan == null) {
                                throw new IOException("CLOSE: Invalid channel id: " + id);
                            }
                            chan.disconnect();
                            if (chan.isOpen()) {
                                StreamChannelManager.this.sendCloseAckCmd(chan);
                            }
                            StreamChannelManager.this.closeChannelCallback(chan);
                            StreamChannelManager.this.channels.remove(id);
                            if (!StreamChannelManager.this.isMyChannel(id)) continue block21;
                            StreamChannelManager.this.freeId(id);
                            continue block21;
                        }
                        case 163: {
                            StreamChannelManager.this.debugPrint("received cmd=CLOSEACK id=" + id);
                            StreamChannel chan = StreamChannelManager.this.channels.get(id);
                            if (chan == null) {
                                throw new IOException("CLOSEACK: Invalid channel id");
                            }
                            if (chan.isOpen()) {
                                throw new IOException("Channel is still open");
                            }
                            chan.disconnect();
                            StreamChannelManager.this.channels.remove(id);
                            if (!StreamChannelManager.this.isMyChannel(id)) continue block21;
                            StreamChannelManager.this.freeId(id);
                            continue block21;
                        }
                        case 165: {
                            StreamChannelManager.this.debugPrint("received cmd=TRANSMIT id=" + id);
                            StreamChannel chan = StreamChannelManager.this.channels.get(id);
                            if (chan == null) {
                                throw new IOException("TRANSMIT: Invalid channel id: " + id);
                            }
                            int len = this.dataIn.readInt();
                            byte[] buf = new byte[len];
                            this.dataIn.readFully(buf, 0, len);
                            chan.receive(buf, len);
                            continue block21;
                        }
                        case 164: {
                            StreamChannel chan = StreamChannelManager.this.channels.get(id);
                            if (chan == null) {
                                throw new IOException("REQUEST: Invalid channel id: " + id);
                            }
                            int req = this.dataIn.readInt();
                            StreamChannelManager.this.debugPrint("received cmd=REQUEST id=" + id + " len=" + req);
                            chan.request(req);
                            continue block21;
                        }
                        case 166: {
                            StreamChannelManager.this.debugPrint("received cmd=CLOSE_INPUT id=" + id);
                            StreamChannel chan = StreamChannelManager.this.channels.get(id);
                            if (chan == null) {
                                throw new IOException("CLOSE: Invalid channel id: " + id);
                            }
                            chan.disconnectInput();
                            continue block21;
                        }
                        case 167: {
                            StreamChannelManager.this.debugPrint("received cmd=CLOSE_OUTPUT id=" + id);
                            StreamChannel chan = StreamChannelManager.this.channels.get(id);
                            if (chan == null) {
                                throw new IOException("CLOSE: Invalid channel id: " + id);
                            }
                            chan.disconnectOutput();
                            continue block21;
                        }
                    }
                    break;
                }
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    System.err.print("invalid command: " + StreamChannelManager.this.dump_byte((byte)cmd) + StreamChannelManager.this.dump_byte((byte)id));
                }
                try {
                    while (true) {
                        byte b = this.dataIn.readByte();
                        System.err.print(StreamChannelManager.this.dump_byte(b));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Invalid command: " + cmd);
                }
            }
            catch (EOFException cmd) {
                StreamChannelManager.this.debugPrint("shutting down manager");
                StreamChannelManager.this.shutdown();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    StreamChannelManager.this.debugPrint("run got exception:" + e.getMessage());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    StreamChannelManager.this.debugPrint("shutting down manager");
                    StreamChannelManager.this.shutdown();
                }
            }
        }

        public void shutdown() {
            try {
                this.dataIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class Sender
    implements Runnable {
        private OutputStream out;
        private BlockingQueue<ByteArrayOutputStream> queue = new LinkedBlockingQueue<ByteArrayOutputStream>();
        private boolean running = true;

        public Sender(OutputStream out) {
            this.out = out;
        }

        public void sendOpenCmd(int id) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeByte(161);
            data.writeByte(id);
            try {
                this.queue.put(bytes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void sendTransmitCmd(int id, byte[] buf, int off, int len) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeByte(165);
            data.writeByte(id);
            data.writeInt(len);
            data.write(buf, off, len);
            try {
                this.queue.put(bytes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void sendCloseCmd(int id) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeByte(162);
            data.writeByte(id);
            try {
                this.queue.put(bytes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void sendCloseAckCmd(int id) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeByte(163);
            data.writeByte(id);
            try {
                this.queue.put(bytes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void sendRequestCmd(int id, int len) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeByte(164);
            data.writeByte(id);
            data.writeInt(len);
            try {
                this.queue.put(bytes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void sendCloseInputCmd(int id) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeByte(166);
            data.writeByte(id);
            try {
                this.queue.put(bytes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void sendCloseOutputCmd(int id) throws IOException {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream data = new DataOutputStream(bytes);
            data.writeByte(167);
            data.writeByte(id);
            try {
                this.queue.put(bytes);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void shutdown() {
            this.running = false;
            try {
                this.queue.put(new ByteArrayOutputStream());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    ByteArrayOutputStream bytes = this.queue.take();
                    if (bytes == null) continue;
                    bytes.writeTo(this.out);
                    this.out.flush();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

