/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.sourcelookup;

import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.SelectionToDeclarationJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;

public class DsfSourceSelectionResolver
implements Runnable {
    private ITextEditor fEditorPage = null;
    private ITextSelection fSelection = null;
    private LineLocation fLineLocation = new LineLocation();
    private IFunctionDeclaration fFunction = null;
    private boolean fSuccessful = false;

    public DsfSourceSelectionResolver() {
    }

    public DsfSourceSelectionResolver(ITextEditor editor, ITextSelection selection) {
        this.fEditorPage = editor;
        this.fSelection = selection;
    }

    @Override
    public void run() {
        ITextSelection selection;
        this.fEditorPage = this.resolveEditor();
        if (this.fEditorPage != null && (selection = this.resolveSelection()) != null) {
            IFunctionDeclaration[] selectedFunctions = this.resolveSelectedFunction(selection);
            IFunctionDeclaration selFunction = null;
            if (selectedFunctions == null || selectedFunctions.length != 1 || selectedFunctions[0] == null) {
                return;
            }
            selFunction = selectedFunctions[0];
            LineLocation selectedLine = this.resolveSelectedLine();
            if (selectedLine == null) {
                return;
            }
            this.fLineLocation = selectedLine;
            this.fFunction = selFunction;
            this.fSuccessful = true;
        }
    }

    public ITextEditor resolveEditor() {
        if (this.fEditorPage != null) {
            return this.fEditorPage;
        }
        final IWorkbench wb = PlatformUI.getWorkbench();
        ResolveEditorRunnable reditorRunnable = new ResolveEditorRunnable(){
            TextEditor result = null;

            @Override
            public void run() {
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                if (win == null || win.getActivePage() == null || win.getActivePage().getActiveEditor() == null) {
                    this.result = null;
                } else {
                    IEditorPart editorPart = win.getActivePage().getActiveEditor();
                    if (editorPart instanceof CEditor) {
                        this.result = (TextEditor)win.getActivePage().getActiveEditor();
                    }
                }
            }

            @Override
            public TextEditor getEditor() {
                return this.result;
            }
        };
        Display.getDefault().syncExec((Runnable)reditorRunnable);
        return reditorRunnable.getEditor();
    }

    private LineLocation resolveSelectedLine() {
        String errorMessage = "";
        IEditorInput input = this.fEditorPage.getEditorInput();
        if (input == null) {
            errorMessage = "Invalid Editor input on selection";
        } else {
            IDocument document = this.fEditorPage.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = "Invalid Editor Document input on selection";
            } else {
                ITextSelection selection = this.resolveSelection();
                if (selection == null) {
                    errorMessage = "Invalid selection. Only textual selections are supported";
                } else {
                    String fileName = null;
                    try {
                        fileName = CDebugUIUtils.getEditorFilePath((IEditorInput)input);
                    }
                    catch (CoreException e) {
                        DsfUIPlugin.log(e);
                        return null;
                    }
                    if (fileName == null) {
                        errorMessage = "Unable to resolve fileName from selection";
                        DsfUIPlugin.logErrorMessage(errorMessage);
                    } else {
                        LineLocation lineLocation = new LineLocation();
                        lineLocation.setFileName(fileName);
                        lineLocation.setLineNumber(selection.getStartLine() + 1);
                        return lineLocation;
                    }
                }
            }
        }
        DsfUIPlugin.logErrorMessage(errorMessage);
        return null;
    }

    public ITextSelection resolveSelection() {
        if (this.fSelection != null) {
            return this.fSelection;
        }
        ISelection selection = this.fEditorPage.getEditorSite().getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    private IFunctionDeclaration[] resolveSelectedFunction(ITextSelection textSelection) {
        if (textSelection != null) {
            SelectionToDeclarationJob job;
            try {
                job = new SelectionToDeclarationJob(this.fEditorPage, textSelection);
                job.schedule();
                job.join();
            }
            catch (CoreException e1) {
                DsfUIPlugin.log(e1);
                return null;
            }
            catch (InterruptedException e) {
                DsfUIPlugin.log(e);
                return null;
            }
            return job.getSelectedFunctions();
        }
        return null;
    }

    public LineLocation getLineLocation() {
        return this.fLineLocation;
    }

    public IFunctionDeclaration getFunction() {
        return this.fFunction;
    }

    public boolean isSuccessful() {
        return this.fSuccessful;
    }

    public class LineLocation {
        private String fileName = null;
        private int lineNumber = 0;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }
    }

    private static interface ResolveEditorRunnable
    extends Runnable {
        public TextEditor getEditor();
    }
}

