/*********************************************************************
 * Copyright (c) 2018 QNX Software Systems and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { IGDBBackend } from '../types/gdb';
import { FrameReference } from '../types/session';
import { MIFrameInfo, MIResponse, MIVariableInfo } from './base';
export interface MIStackInfoDepthResponse extends MIResponse {
    depth: string;
}
export interface MIStackListVariablesResponse extends MIResponse {
    variables: MIVariableInfo[];
}
export declare function sendStackInfoDepth(gdb: IGDBBackend, params: {
    maxDepth: number;
    threadId?: number;
}): Promise<MIStackInfoDepthResponse>;
export declare function sendStackListFramesRequest(gdb: IGDBBackend, params: {
    noFrameFilters?: boolean;
    lowFrame?: number;
    highFrame?: number;
    threadId?: number;
}): Promise<{
    stack: MIFrameInfo[];
}>;
export declare function sendStackSelectFrame(gdb: IGDBBackend, params: {
    frameNum: number;
}): Promise<MIResponse>;
export declare function sendStackListVariables(gdb: IGDBBackend, params: {
    frameRef: FrameReference | undefined;
    printValues: 'no-values' | 'all-values' | 'simple-values';
    noFrameFilters?: boolean;
    skipUnavailable?: boolean;
}): Promise<MIStackListVariablesResponse>;
