/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrExists;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrValues;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class MergeFilterExistsIntoPrecedingGraphTransform
extends BaseTransform {
    private MergeFilterExistsIntoPrecedingGraphTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrFilter f;
            IrNode n = in.get(i);
            if (i + 1 < in.size() && n instanceof IrGraph && in.get(i + 1) instanceof IrFilter) {
                IrGraph g1 = (IrGraph)n;
                IrFilter f2 = (IrFilter)in.get(i + 1);
                if (f2.getBody() instanceof IrExists) {
                    IrExists ex = (IrExists)f2.getBody();
                    if (!ex.isNewScope() && !f2.isNewScope()) {
                        out.add(n);
                        continue;
                    }
                    IrBGP exWhere = ex.getWhere();
                    if (exWhere != null) {
                        IrBGP unwrapped = new IrBGP(false);
                        boolean canUnwrap = MergeFilterExistsIntoPrecedingGraphTransform.unwrapInto(exWhere, g1.getGraph(), unwrapped);
                        if (canUnwrap && !unwrapped.getLines().isEmpty()) {
                            IrBGP inner = new IrBGP(false);
                            if (g1.getWhere() != null) {
                                for (IrNode ln : g1.getWhere().getLines()) {
                                    inner.add(ln);
                                }
                            }
                            IrExists newExists = new IrExists(unwrapped, ex.isNewScope());
                            IrFilter newFilter = new IrFilter(newExists, false);
                            inner.add(newFilter);
                            out.add(new IrGraph(g1.getGraph(), inner, g1.isNewScope()));
                            ++i;
                            continue;
                        }
                    }
                }
            }
            if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                out.add(new IrGraph(g.getGraph(), MergeFilterExistsIntoPrecedingGraphTransform.apply(g.getWhere()), g.isNewScope()));
                continue;
            }
            if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(MergeFilterExistsIntoPrecedingGraphTransform.apply(o.getWhere()), o.isNewScope());
                no.setNewScope(o.isNewScope());
                out.add(no);
                continue;
            }
            if (n instanceof IrMinus) {
                IrMinus m = (IrMinus)n;
                out.add(new IrMinus(MergeFilterExistsIntoPrecedingGraphTransform.apply(m.getWhere()), m.isNewScope()));
                continue;
            }
            if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                IrUnion u2 = new IrUnion(u.isNewScope());
                for (IrBGP b : u.getBranches()) {
                    u2.addBranch(MergeFilterExistsIntoPrecedingGraphTransform.apply(b));
                }
                out.add(u2);
                continue;
            }
            if (n instanceof IrService) {
                IrService s = (IrService)n;
                out.add(new IrService(s.getServiceRefText(), s.isSilent(), MergeFilterExistsIntoPrecedingGraphTransform.apply(s.getWhere()), s.isNewScope()));
                continue;
            }
            if (n instanceof IrSubSelect) {
                out.add(n);
                continue;
            }
            if (n instanceof IrFilter && (f = (IrFilter)n).getBody() instanceof IrExists) {
                IrExists ex = (IrExists)f.getBody();
                IrBGP inner = MergeFilterExistsIntoPrecedingGraphTransform.apply(ex.getWhere());
                out.add(new IrFilter(new IrExists(inner, ex.isNewScope()), f.isNewScope()));
                continue;
            }
            out.add(n);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    private static boolean unwrapInto(IrNode node, Var graphRef, IrBGP out) {
        if (node == null) {
            return false;
        }
        if (node instanceof IrBGP) {
            IrBGP w = (IrBGP)node;
            for (IrNode ln : w.getLines()) {
                if (MergeFilterExistsIntoPrecedingGraphTransform.unwrapInto(ln, graphRef, out)) continue;
                return false;
            }
            return true;
        }
        if (node instanceof IrGraph) {
            IrGraph ig = (IrGraph)node;
            if (!MergeFilterExistsIntoPrecedingGraphTransform.sameVarOrValue(graphRef, ig.getGraph())) {
                return false;
            }
            if (ig.getWhere() != null) {
                for (IrNode ln : ig.getWhere().getLines()) {
                    out.add(ln);
                }
            }
            return true;
        }
        if (node instanceof IrOptional) {
            IrBGP inner;
            IrOptional o = (IrOptional)node;
            IrBGP ow = o.getWhere();
            if (ow != null && ow.getLines().size() == 1 && ow.getLines().get(0) instanceof IrGraph) {
                IrGraph ig = (IrGraph)ow.getLines().get(0);
                if (!MergeFilterExistsIntoPrecedingGraphTransform.sameVarOrValue(graphRef, ig.getGraph())) {
                    return false;
                }
                IrOptional no = new IrOptional(ig.getWhere(), o.isNewScope());
                no.setNewScope(o.isNewScope());
                out.add(no);
                return true;
            }
            if (ow != null && ow.getLines().size() == 1 && ow.getLines().get(0) instanceof IrBGP && (inner = (IrBGP)ow.getLines().get(0)).getLines().size() == 1 && inner.getLines().get(0) instanceof IrGraph) {
                IrGraph ig = (IrGraph)inner.getLines().get(0);
                if (!MergeFilterExistsIntoPrecedingGraphTransform.sameVarOrValue(graphRef, ig.getGraph())) {
                    return false;
                }
                IrOptional no = new IrOptional(ig.getWhere(), o.isNewScope());
                no.setNewScope(o.isNewScope());
                out.add(no);
                return true;
            }
            return false;
        }
        if (node instanceof IrValues) {
            out.add(node);
            return true;
        }
        return false;
    }
}

