/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class CoalesceAdjacentGraphsTransform
extends BaseTransform {
    private CoalesceAdjacentGraphsTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            if (n instanceof IrGraph) {
                int j;
                IrGraph g1 = (IrGraph)n;
                IrBGP merged = new IrBGP(false);
                if (g1.getWhere() != null) {
                    g1.getWhere().getLines().forEach(merged::add);
                }
                for (j = i + 1; j < in.size() && in.get(j) instanceof IrGraph; ++j) {
                    IrGraph gj = (IrGraph)in.get(j);
                    if (!CoalesceAdjacentGraphsTransform.sameVarOrValue(g1.getGraph(), gj.getGraph())) break;
                    if (gj.getWhere() == null) continue;
                    gj.getWhere().getLines().forEach(merged::add);
                }
                out.add(new IrGraph(g1.getGraph(), merged, g1.isNewScope()));
                i = j - 1;
                continue;
            }
            IrNode rec = BaseTransform.rewriteContainers(n, CoalesceAdjacentGraphsTransform::apply);
            out.add(rec);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }
}

