/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrTripleLike;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.PathTextUtils;
import org.eclipse.rdf4j.queryrender.sparql.util.VarUtils;

public class BaseTransform {
    public static final String ANON_PATH_PREFIX = "_anon_path_";
    public static final String ANON_PATH_INVERSE_PREFIX = "_anon_path_inverse_";

    public static boolean isConstantIriPredicate(IrStatementPattern sp) {
        if (sp == null) {
            return false;
        }
        Var p = sp.getPredicate();
        return p != null && p.hasValue() && p.getValue() instanceof IRI;
    }

    public static String iri(Var pred, TupleExprIRRenderer r) {
        if (pred == null || !pred.hasValue() || !(pred.getValue() instanceof IRI)) {
            return null;
        }
        return r.convertIRIToString((IRI)pred.getValue());
    }

    public static String normalizeCompactNps(String path) {
        if (path == null) {
            return null;
        }
        String t = path.trim();
        if (t.isEmpty()) {
            return t;
        }
        if (t.startsWith("!(") && t.endsWith(")")) {
            return t;
        }
        if (t.startsWith("!^")) {
            return "!(" + t.substring(1) + ")";
        }
        if (t.startsWith("!") && (t.length() == 1 || t.charAt(1) != '(')) {
            return "!(" + t.substring(1) + ")";
        }
        return t;
    }

    public static String mergeNpsMembers(String a, String b) {
        if (a == null || b == null) {
            return a;
        }
        int a1 = a.indexOf(40);
        int a2 = a.lastIndexOf(41);
        int b1 = b.indexOf(40);
        int b2 = b.lastIndexOf(41);
        if (a1 < 0 || a2 < 0 || b1 < 0 || b2 < 0) {
            return a;
        }
        String ia = a.substring(a1 + 1, a2).trim();
        String ib = b.substring(b1 + 1, b2).trim();
        if (ia.isEmpty()) {
            return b;
        }
        if (ib.isEmpty()) {
            return a;
        }
        return "!(" + ia + "|" + ib + ")";
    }

    public static boolean unionIsExplicitAndAllBranchesScoped(IrUnion u) {
        if (u == null || !u.isNewScope()) {
            return false;
        }
        if (u.getBranches() == null || u.getBranches().isEmpty()) {
            return false;
        }
        for (IrBGP b : u.getBranches()) {
            if (b.isNewScope() || b.getLines().size() == 1 && b.getLines().get(0).isNewScope()) continue;
            return false;
        }
        return true;
    }

    public static IrNode rewriteContainers(IrNode n, Function<IrBGP, IrBGP> f) {
        if (n == null) {
            return null;
        }
        if (n instanceof IrGraph) {
            IrGraph g = (IrGraph)n;
            return new IrGraph(g.getGraph(), f.apply(g.getWhere()), g.isNewScope());
        }
        if (n instanceof IrOptional) {
            IrOptional o = (IrOptional)n;
            return new IrOptional(f.apply(o.getWhere()), o.isNewScope());
        }
        if (n instanceof IrMinus) {
            IrMinus m = (IrMinus)n;
            return new IrMinus(f.apply(m.getWhere()), m.isNewScope());
        }
        if (n instanceof IrService) {
            IrService s = (IrService)n;
            return new IrService(s.getServiceRefText(), s.isSilent(), f.apply(s.getWhere()), s.isNewScope());
        }
        if (n instanceof IrUnion) {
            IrUnion u = (IrUnion)n;
            IrUnion u2 = new IrUnion(u.isNewScope());
            for (IrBGP b : u.getBranches()) {
                u2.addBranch(f.apply(b));
            }
            u2.setNewScope(u.isNewScope());
            return u2;
        }
        return n;
    }

    public static IrBGP bgpWithLines(IrBGP original, List<IrNode> lines) {
        IrBGP res = new IrBGP(original.isNewScope());
        if (lines != null) {
            for (IrNode n : lines) {
                res.add(n);
            }
        }
        res.setNewScope(original.isNewScope());
        return res;
    }

    public static void copyAllExcept(IrBGP from, IrBGP to, IrNode except) {
        if (from == null) {
            return;
        }
        for (IrNode ln : from.getLines()) {
            if (ln == except) continue;
            to.add(ln);
        }
    }

    public static IrBGP fuseAdjacentPtThenPt(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            if (n instanceof IrPathTriple && i + 1 < in.size() && in.get(i + 1) instanceof IrPathTriple) {
                String fusedPath;
                IrPathTriple a = (IrPathTriple)n;
                IrPathTriple b = (IrPathTriple)in.get(i + 1);
                Var bridge = a.getObject();
                if (BaseTransform.sameVar(bridge, b.getSubject()) && BaseTransform.isAnonPathVar(bridge)) {
                    fusedPath = "(" + a.getPathText() + ")/(" + b.getPathText() + ")";
                    out.add(new IrPathTriple(a.getSubject(), a.getSubjectOverride(), fusedPath, b.getObject(), b.getObjectOverride(), IrPathTriple.mergePathVars(a, b), false));
                    ++i;
                    continue;
                }
                if (BaseTransform.sameVar(bridge, b.getObject()) && BaseTransform.isAnonPathVar(bridge)) {
                    fusedPath = "(" + a.getPathText() + ")/^(" + b.getPathText() + ")";
                    out.add(new IrPathTriple(a.getSubject(), a.getSubjectOverride(), fusedPath, b.getSubject(), b.getSubjectOverride(), IrPathTriple.mergePathVars(a, b), false));
                    ++i;
                    continue;
                }
                Var aSubj = a.getSubject();
                if (BaseTransform.isAnonPathVar(aSubj)) {
                    String left;
                    boolean aIsNps;
                    String aPath = a.getPathText();
                    boolean bl = aIsNps = aPath != null && aPath.trim().startsWith("!(");
                    if (aIsNps) {
                        out.add(n);
                        continue;
                    }
                    if (BaseTransform.sameVar(aSubj, b.getSubject())) {
                        left = BaseTransform.invertNegatedPropertySet(aPath);
                        if (left == null) {
                            left = PathTextUtils.wrapForInverse(aPath);
                        }
                        String fusedPath2 = left + "/" + PathTextUtils.wrapForSequence(b.getPathText());
                        out.add(new IrPathTriple(a.getObject(), a.getObjectOverride(), fusedPath2, b.getObject(), b.getObjectOverride(), IrPathTriple.mergePathVars(a, b), false));
                        ++i;
                        continue;
                    }
                    if (BaseTransform.sameVar(aSubj, b.getObject())) {
                        left = BaseTransform.invertNegatedPropertySet(aPath);
                        if (left == null) {
                            left = PathTextUtils.wrapForInverse(aPath);
                        }
                        String right = PathTextUtils.wrapForInverse(b.getPathText());
                        String fusedPath3 = left + "/" + right;
                        out.add(new IrPathTriple(a.getObject(), a.getObjectOverride(), fusedPath3, b.getSubject(), b.getSubjectOverride(), IrPathTriple.mergePathVars(a, b), false));
                        ++i;
                        continue;
                    }
                }
                out.add(n);
                continue;
            }
            out.add(n);
        }
        IrBGP res = new IrBGP(bgp.isNewScope());
        out.forEach(res::add);
        res.setNewScope(bgp.isNewScope());
        return res;
    }

    public static IrBGP fusePtSpPtSequence(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode a = in.get(i);
            if (a instanceof IrPathTriple && i + 2 < in.size() && in.get(i + 1) instanceof IrStatementPattern && in.get(i + 2) instanceof IrPathTriple) {
                IrPathTriple ptA = (IrPathTriple)a;
                IrStatementPattern spB = (IrStatementPattern)in.get(i + 1);
                IrPathTriple ptC = (IrPathTriple)in.get(i + 2);
                Var bPred = spB.getPredicate();
                if (BaseTransform.isConstantIriPredicate(spB) && BaseTransform.sameVar(ptA.getObject(), spB.getObject()) && BaseTransform.isAnonPathVar(ptA.getObject()) && BaseTransform.sameVar(spB.getSubject(), ptC.getSubject()) && BaseTransform.isAnonPathVar(spB.getSubject()) && BaseTransform.isAnonPathVar(spB.getObject())) {
                    String fusedPath = "^" + BaseTransform.iri(bPred, r) + "/" + ptC.getPathText();
                    IrPathTriple d = new IrPathTriple(spB.getObject(), spB.getObjectOverride(), fusedPath, ptC.getObject(), ptC.getObjectOverride(), IrPathTriple.mergePathVars(ptC), false);
                    out.add(ptA);
                    out.add(d);
                    i += 2;
                    continue;
                }
            }
            out.add(a);
        }
        IrBGP res = new IrBGP(bgp.isNewScope());
        out.forEach(res::add);
        res.setNewScope(bgp.isNewScope());
        return res;
    }

    public static IrBGP orientBareNpsForNext(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            if (n instanceof IrPathTriple) {
                String s;
                IrPathTriple pt = (IrPathTriple)n;
                String ptxtGlobal = pt.getPathText();
                if (ptxtGlobal != null && ptxtGlobal.indexOf(124) >= 0) {
                    out.add(pt);
                    continue;
                }
                String ptxt = pt.getPathText();
                if (ptxt == null || !(s = ptxt.trim()).startsWith("!(") || s.endsWith(")")) {
                    // empty if block
                }
                out.add(pt);
                continue;
            }
            if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                out.add(new IrGraph(g.getGraph(), BaseTransform.orientBareNpsForNext(g.getWhere()), g.isNewScope()));
                continue;
            }
            if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(BaseTransform.orientBareNpsForNext(o.getWhere()), o.isNewScope());
                no.setNewScope(o.isNewScope());
                out.add(no);
                continue;
            }
            if (n instanceof IrMinus) {
                IrMinus m = (IrMinus)n;
                out.add(new IrMinus(BaseTransform.orientBareNpsForNext(m.getWhere()), m.isNewScope()));
                continue;
            }
            if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                IrUnion u2 = new IrUnion(u.isNewScope());
                for (IrBGP b : u.getBranches()) {
                    u2.addBranch(BaseTransform.orientBareNpsForNext(b));
                }
                out.add(u2);
                continue;
            }
            if (n instanceof IrService) {
                IrService s = (IrService)n;
                out.add(new IrService(s.getServiceRefText(), s.isSilent(), BaseTransform.orientBareNpsForNext(s.getWhere()), s.isNewScope()));
                continue;
            }
            out.add(n);
        }
        IrBGP res = new IrBGP(bgp.isNewScope());
        out.forEach(res::add);
        res.setNewScope(bgp.isNewScope());
        return res;
    }

    public static IrBGP fuseAdjacentSpThenPt(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = in.get(i);
            if (i + 1 < in.size() && n instanceof IrStatementPattern && in.get(i + 1) instanceof IrPathTriple) {
                IrStatementPattern sp = (IrStatementPattern)n;
                Var p = sp.getPredicate();
                if (BaseTransform.isConstantIriPredicate(sp)) {
                    String fused;
                    IrPathTriple pt = (IrPathTriple)in.get(i + 1);
                    if (BaseTransform.sameVar(sp.getObject(), pt.getSubject()) && BaseTransform.isAnonPathVar(pt.getSubject())) {
                        fused = BaseTransform.iri(p, r) + "/" + pt.getPathText();
                        out.add(new IrPathTriple(sp.getSubject(), sp.getSubjectOverride(), fused, pt.getObject(), pt.getObjectOverride(), IrPathTriple.mergePathVars(pt), false));
                        ++i;
                        continue;
                    }
                    if (BaseTransform.sameVar(sp.getSubject(), pt.getObject()) && BaseTransform.isAnonPathVar(pt.getObject())) {
                        fused = pt.getPathText() + "/^" + BaseTransform.iri(p, r);
                        out.add(new IrPathTriple(pt.getSubject(), pt.getSubjectOverride(), fused, sp.getObject(), sp.getObjectOverride(), IrPathTriple.mergePathVars(pt), false));
                        ++i;
                        continue;
                    }
                }
            }
            out.add(n);
        }
        IrBGP res = new IrBGP(bgp.isNewScope());
        out.forEach(res::add);
        res.setNewScope(bgp.isNewScope());
        return res;
    }

    public static IrBGP joinPathWithLaterSp(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> in = new ArrayList<IrNode>(bgp.getLines());
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        HashSet<IrStatementPattern> removed = new HashSet<IrStatementPattern>();
        for (int i = 0; i < in.size(); ++i) {
            IrNode n = (IrNode)in.get(i);
            if (removed.contains(n)) continue;
            if (n instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)n;
                Var objVar = pt.getObject();
                if (BaseTransform.isAnonPathVar(objVar)) {
                    IrStatementPattern join = null;
                    boolean inverse = false;
                    for (int j = i + 1; j < in.size(); ++j) {
                        IrStatementPattern sp;
                        IrNode m = (IrNode)in.get(j);
                        if (!(m instanceof IrStatementPattern) || !BaseTransform.isConstantIriPredicate(sp = (IrStatementPattern)m)) continue;
                        if (j + 1 < in.size() && in.get(j + 1) instanceof IrPathTriple) {
                            IrPathTriple nextPt = (IrPathTriple)in.get(j + 1);
                            if (BaseTransform.sameVar(sp.getSubject(), nextPt.getSubject()) || BaseTransform.sameVar(sp.getObject(), nextPt.getSubject())) continue;
                        }
                        if (BaseTransform.sameVar(objVar, sp.getSubject()) && BaseTransform.isAnonPathVar(sp.getObject())) {
                            join = sp;
                            inverse = false;
                            break;
                        }
                        if (!BaseTransform.sameVar(objVar, sp.getObject()) || !BaseTransform.isAnonPathVar(sp.getSubject())) continue;
                        join = sp;
                        inverse = true;
                        break;
                    }
                    if (join != null) {
                        String step = BaseTransform.iri(join.getPredicate(), r);
                        String newPath = pt.getPathText() + "/" + (inverse ? "^" : "") + step;
                        Var newEnd = inverse ? join.getSubject() : join.getObject();
                        IrNode newEndOverride = inverse ? join.getSubjectOverride() : join.getObjectOverride();
                        pt = new IrPathTriple(pt.getSubject(), pt.getSubjectOverride(), newPath, newEnd, newEndOverride, pt.getPathVars(), pt.isNewScope());
                        removed.add(join);
                    }
                }
                out.add(pt);
                continue;
            }
            if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                IrBGP inner = g.getWhere();
                inner = BaseTransform.joinPathWithLaterSp(inner, r);
                inner = BaseTransform.fuseAltInverseTailBGP(inner, r);
                out.add(new IrGraph(g.getGraph(), inner, g.isNewScope()));
                continue;
            }
            if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(BaseTransform.joinPathWithLaterSp(o.getWhere(), r), o.isNewScope());
                out.add(no);
                continue;
            }
            if (n instanceof IrMinus) {
                IrMinus m = (IrMinus)n;
                out.add(new IrMinus(BaseTransform.joinPathWithLaterSp(m.getWhere(), r), m.isNewScope()));
                continue;
            }
            if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                IrUnion u2 = new IrUnion(u.isNewScope());
                for (IrBGP b : u.getBranches()) {
                    u2.addBranch(BaseTransform.joinPathWithLaterSp(b, r));
                }
                out.add(u2);
                continue;
            }
            if (n instanceof IrService) {
                IrService s = (IrService)n;
                out.add(new IrService(s.getServiceRefText(), s.isSilent(), BaseTransform.joinPathWithLaterSp(s.getWhere(), r), s.isNewScope()));
                continue;
            }
            if (n instanceof IrSubSelect) {
                out.add(n);
                continue;
            }
            out.add(n);
        }
        IrBGP res = new IrBGP(bgp.isNewScope());
        for (IrNode n2 : out) {
            if (removed.contains(n2)) continue;
            res.add(n2);
        }
        return res;
    }

    public static boolean sameVar(Var a, Var b) {
        return VarUtils.sameVar(a, b);
    }

    public static boolean sameVarOrValue(Var a, Var b) {
        return VarUtils.sameVarOrValue(a, b);
    }

    public static boolean isAnonPathVar(Var v) {
        return VarUtils.isAnonPathVar(v);
    }

    public static boolean isAnonPathInverseVar(Var v) {
        return VarUtils.isAnonPathInverseVar(v);
    }

    public static boolean branchHasAnonPathBridge(IrBGP branch) {
        if (branch == null) {
            return false;
        }
        for (IrNode ln : branch.getLines()) {
            IrMinus m;
            IrOptional o;
            IrGraph g;
            IrPathTriple pt;
            if (ln instanceof IrStatementPattern) {
                IrStatementPattern sp = (IrStatementPattern)ln;
                Var s = sp.getSubject();
                Var o2 = sp.getObject();
                Var p = sp.getPredicate();
                if (!BaseTransform.isAnonPathVar(s) && !BaseTransform.isAnonPathInverseVar(s) && !BaseTransform.isAnonPathVar(o2) && !BaseTransform.isAnonPathInverseVar(o2) && !BaseTransform.isAnonPathVar(p) && !BaseTransform.isAnonPathInverseVar(p)) continue;
                return true;
            }
            if (!(ln instanceof IrPathTriple ? BaseTransform.isAnonPathVar((pt = (IrPathTriple)ln).getSubject()) || BaseTransform.isAnonPathInverseVar(pt.getSubject()) || BaseTransform.isAnonPathVar(pt.getObject()) || BaseTransform.isAnonPathInverseVar(pt.getObject()) : (ln instanceof IrGraph ? BaseTransform.branchHasAnonPathBridge((g = (IrGraph)ln).getWhere()) : (ln instanceof IrOptional ? BaseTransform.branchHasAnonPathBridge((o = (IrOptional)ln).getWhere()) : (ln instanceof IrMinus ? BaseTransform.branchHasAnonPathBridge((m = (IrMinus)ln).getWhere()) : ln instanceof IrBGP && BaseTransform.branchHasAnonPathBridge((IrBGP)ln)))))) continue;
            return true;
        }
        return false;
    }

    public static boolean unionBranchesAllHaveAnonPathBridge(IrUnion u) {
        if (BaseTransform.unionIsExplicitAndAllBranchesScoped(u)) {
            return false;
        }
        if (u == null || u.getBranches().isEmpty()) {
            return false;
        }
        for (IrBGP b : u.getBranches()) {
            if (BaseTransform.branchHasAnonPathBridge(b)) continue;
            return false;
        }
        return true;
    }

    public static boolean unionBranchesShareCommonAnonPathVarName(IrUnion u) {
        if (BaseTransform.unionIsExplicitAndAllBranchesScoped(u)) {
            return false;
        }
        if (u == null || u.getBranches().isEmpty()) {
            return false;
        }
        HashSet<String> common = null;
        for (IrBGP b : u.getBranches()) {
            HashSet<String> names = new HashSet<String>();
            BaseTransform.collectAnonPathVarNames(b, names);
            if (names.isEmpty()) {
                return false;
            }
            if (common == null) {
                common = new HashSet<String>(names);
                continue;
            }
            common.retainAll(names);
            if (!common.isEmpty()) continue;
            return false;
        }
        return common != null && !common.isEmpty();
    }

    public static boolean unionBranchesShareAnonPathVarWithAllowedRoleMapping(IrUnion u) {
        if (BaseTransform.unionIsExplicitAndAllBranchesScoped(u)) {
            return false;
        }
        if (u == null || u.getBranches().size() != 2) {
            return false;
        }
        Set<Var> aVars = u.getBranches().get(0).getVars();
        Set<Var> bVars = u.getBranches().get(1).getVars();
        if (aVars == null || bVars == null || aVars.isEmpty() || bVars.isEmpty()) {
            return false;
        }
        HashSet<String> aNames = new HashSet<String>();
        HashSet<String> bNames = new HashSet<String>();
        for (Var v : aVars) {
            if (!BaseTransform.isAnonPathVar(v) && !BaseTransform.isAnonPathInverseVar(v)) continue;
            aNames.add(v.getName());
        }
        for (Var v : bVars) {
            if (!BaseTransform.isAnonPathVar(v) && !BaseTransform.isAnonPathInverseVar(v)) continue;
            bNames.add(v.getName());
        }
        return !aNames.isEmpty() && !bNames.isEmpty() && BaseTransform.intersects(aNames, bNames);
    }

    private static boolean intersects(Set<String> a, Set<String> b) {
        if (a == null || b == null) {
            return false;
        }
        for (String x : a) {
            if (!b.contains(x)) continue;
            return true;
        }
        return false;
    }

    private static void collectAnonPathVarNames(IrBGP b, Set<String> out) {
        if (b == null) {
            return;
        }
        for (IrNode ln : b.getLines()) {
            Var o;
            Var s;
            if (ln instanceof IrStatementPattern) {
                IrStatementPattern sp = (IrStatementPattern)ln;
                s = sp.getSubject();
                o = sp.getObject();
                Var p = sp.getPredicate();
                if (BaseTransform.isAnonPathVar(s) || BaseTransform.isAnonPathInverseVar(s)) {
                    out.add(s.getName());
                }
                if (BaseTransform.isAnonPathVar(o) || BaseTransform.isAnonPathInverseVar(o)) {
                    out.add(o.getName());
                }
                if (!BaseTransform.isAnonPathVar(p) && !BaseTransform.isAnonPathInverseVar(p)) continue;
                out.add(p.getName());
                continue;
            }
            if (ln instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)ln;
                s = pt.getSubject();
                o = pt.getObject();
                if (BaseTransform.isAnonPathVar(s) || BaseTransform.isAnonPathInverseVar(s)) {
                    out.add(s.getName());
                }
                if (!BaseTransform.isAnonPathVar(o) && !BaseTransform.isAnonPathInverseVar(o)) continue;
                out.add(o.getName());
                continue;
            }
            if (ln instanceof IrGraph) {
                BaseTransform.collectAnonPathVarNames(((IrGraph)ln).getWhere(), out);
                continue;
            }
            if (ln instanceof IrOptional) {
                BaseTransform.collectAnonPathVarNames(((IrOptional)ln).getWhere(), out);
                continue;
            }
            if (ln instanceof IrMinus) {
                BaseTransform.collectAnonPathVarNames(((IrMinus)ln).getWhere(), out);
                continue;
            }
            if (ln instanceof IrUnion) {
                for (IrBGP br : ((IrUnion)ln).getBranches()) {
                    BaseTransform.collectAnonPathVarNames(br, out);
                }
                continue;
            }
            if (!(ln instanceof IrBGP)) continue;
            BaseTransform.collectAnonPathVarNames((IrBGP)ln, out);
        }
    }

    public static String invertNegatedPropertySet(String npsText) {
        if (npsText == null) {
            return null;
        }
        String s = npsText.trim();
        if (!s.startsWith("!(") || !s.endsWith(")")) {
            return null;
        }
        String inner = s.substring(2, s.length() - 1);
        if (inner.isEmpty()) {
            return s;
        }
        String[] toks = inner.split("\\|");
        ArrayList<Object> out = new ArrayList<Object>(toks.length);
        for (String tok : toks) {
            String t = tok.trim();
            if (t.isEmpty()) continue;
            if (t.startsWith("^")) {
                out.add(t.substring(1));
                continue;
            }
            out.add("^" + t);
        }
        if (out.isEmpty()) {
            return s;
        }
        return "!(" + String.join((CharSequence)"|", out) + ")";
    }

    public static IrBGP fuseAltInverseTailBGP(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        List<IrNode> in = bgp.getLines();
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        HashSet<Object> removed = new HashSet<Object>();
        HashMap<String, List> bySubject = new HashMap<String, List>();
        HashMap<String, List> byObject = new HashMap<String, List>();
        for (IrNode n : in) {
            IrStatementPattern sp;
            Var pv;
            if (!(n instanceof IrStatementPattern) || (pv = (sp = (IrStatementPattern)n).getPredicate()) == null || !pv.hasValue() || !(pv.getValue() instanceof IRI)) continue;
            String sTxt = BaseTransform.varOrValue(sp.getSubject(), r);
            String oTxt = BaseTransform.varOrValue(sp.getObject(), r);
            if (sp.getObject() != null && !BaseTransform.isAnonPathVar(sp.getSubject()) && oTxt != null && oTxt.startsWith("?")) {
                byObject.computeIfAbsent(oTxt, k -> new ArrayList()).add(sp);
            }
            if (sp.getSubject() == null || BaseTransform.isAnonPathVar(sp.getObject()) || sTxt == null || !sTxt.startsWith("?")) continue;
            bySubject.computeIfAbsent(sTxt, k -> new ArrayList()).add(sp);
        }
        for (IrNode n : in) {
            if (removed.contains(n)) continue;
            if (n instanceof IrPathTriple) {
                String bridge;
                Object sp3;
                IrPathTriple pt = (IrPathTriple)n;
                String headBridge = BaseTransform.varOrValue(pt.getSubject(), r);
                if (headBridge != null && headBridge.startsWith("?") && BaseTransform.isAnonPathVar(pt.getSubject())) {
                    List ho;
                    Object head = null;
                    boolean headInverse = true;
                    List hs = (List)bySubject.get(headBridge);
                    if (hs != null) {
                        for (Object sp2 : hs) {
                            if (removed.contains(sp2) || ((IrStatementPattern)sp2).getPredicate() == null || !((IrStatementPattern)sp2).getPredicate().hasValue() || !(((IrStatementPattern)sp2).getPredicate().getValue() instanceof IRI)) continue;
                            head = sp2;
                            headInverse = true;
                            break;
                        }
                    }
                    if (head == null && (ho = (List)byObject.get(headBridge)) != null) {
                        Object sp2;
                        sp2 = ho.iterator();
                        while (sp2.hasNext()) {
                            sp3 = (IrStatementPattern)sp2.next();
                            if (removed.contains(sp3) || ((IrStatementPattern)sp3).getPredicate() == null || !((IrStatementPattern)sp3).getPredicate().hasValue() || !(((IrStatementPattern)sp3).getPredicate().getValue() instanceof IRI)) continue;
                            head = sp3;
                            headInverse = false;
                            break;
                        }
                    }
                    if (head != null) {
                        String ptxt = BaseTransform.iri(((IrStatementPattern)head).getPredicate(), r);
                        String prefix = (headInverse ? "^" : "") + ptxt + "/";
                        Var newStart = headInverse ? ((IrTripleLike)head).getObject() : ((IrTripleLike)head).getSubject();
                        IrNode newStartOverride = headInverse ? ((IrTripleLike)head).getObjectOverride() : ((IrTripleLike)head).getSubjectOverride();
                        pt = new IrPathTriple(newStart, newStartOverride, (String)prefix + pt.getPathText(), pt.getObject(), pt.getObjectOverride(), pt.getPathVars(), pt.isNewScope());
                        removed.add(head);
                    }
                }
                if ((bridge = BaseTransform.varOrValue(pt.getObject(), r)) != null && bridge.startsWith("?")) {
                    List bySub;
                    if (!BaseTransform.isAnonPathVar(pt.getObject())) {
                        out.add(pt);
                        continue;
                    }
                    Object join = null;
                    boolean inverse = true;
                    List byObj = (List)byObject.get(bridge);
                    if (byObj != null) {
                        for (Object sp3 : byObj) {
                            if (removed.contains(sp3)) continue;
                            join = sp3;
                            inverse = true;
                            break;
                        }
                    }
                    if (join == null && (bySub = (List)bySubject.get(bridge)) != null) {
                        sp3 = bySub.iterator();
                        while (sp3.hasNext()) {
                            IrStatementPattern sp4 = (IrStatementPattern)sp3.next();
                            if (removed.contains(sp4)) continue;
                            join = sp4;
                            inverse = false;
                            break;
                        }
                    }
                    if (join != null) {
                        String step = BaseTransform.iri(((IrStatementPattern)join).getPredicate(), r);
                        String newPath = pt.getPathText() + "/" + (inverse ? "^" : "") + step;
                        Var newEnd = inverse ? ((IrTripleLike)join).getSubject() : ((IrTripleLike)join).getObject();
                        IrNode newEndOverride = inverse ? ((IrTripleLike)join).getSubjectOverride() : ((IrTripleLike)join).getObjectOverride();
                        pt = new IrPathTriple(pt.getSubject(), pt.getSubjectOverride(), newPath, newEnd, newEndOverride, pt.getPathVars(), pt.isNewScope());
                        removed.add(join);
                    }
                }
                out.add(pt);
                continue;
            }
            if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                out.add(new IrGraph(g.getGraph(), BaseTransform.fuseAltInverseTailBGP(g.getWhere(), r), g.isNewScope()));
                continue;
            }
            if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(BaseTransform.fuseAltInverseTailBGP(o.getWhere(), r), o.isNewScope());
                no.setNewScope(o.isNewScope());
                out.add(no);
                continue;
            }
            if (n instanceof IrMinus) {
                IrMinus m = (IrMinus)n;
                out.add(new IrMinus(BaseTransform.fuseAltInverseTailBGP(m.getWhere(), r), m.isNewScope()));
                continue;
            }
            if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                IrUnion u2 = new IrUnion(u.isNewScope());
                for (IrBGP b : u.getBranches()) {
                    u2.addBranch(BaseTransform.fuseAltInverseTailBGP(b, r));
                }
                out.add(u2);
                continue;
            }
            if (n instanceof IrService) {
                IrService s = (IrService)n;
                out.add(new IrService(s.getServiceRefText(), s.isSilent(), BaseTransform.fuseAltInverseTailBGP(s.getWhere(), r), s.isNewScope()));
                continue;
            }
            out.add(n);
        }
        IrBGP res = new IrBGP(bgp.isNewScope());
        for (IrNode n2 : out) {
            if (removed.contains(n2)) continue;
            res.add(n2);
        }
        res.setNewScope(bgp.isNewScope());
        return res;
    }

    public static String varOrValue(Var v, TupleExprIRRenderer r) {
        if (v == null) {
            return "?_";
        }
        if (v.hasValue()) {
            return r.convertValueToString(v.getValue());
        }
        return "?" + v.getName();
    }
}

