/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public class IrExists
extends IrNode {
    private final IrBGP where;

    public IrExists(IrBGP where, boolean newScope) {
        super(newScope);
        this.where = where;
    }

    public IrBGP getWhere() {
        return this.where;
    }

    @Override
    public void print(IrPrinter p) {
        p.append("EXISTS ");
        if (this.where != null) {
            this.where.print(p);
        } else {
            p.openBlock();
            p.closeBlock();
        }
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        IrBGP newWhere = this.where;
        if (newWhere != null) {
            IrNode t = (IrNode)op.apply(newWhere);
            if ((t = t.transformChildren(op)) instanceof IrBGP) {
                newWhere = (IrBGP)t;
            }
        }
        return new IrExists(newWhere, this.isNewScope());
    }

    @Override
    public Set<Var> getVars() {
        return this.where == null ? Collections.emptySet() : this.where.getVars();
    }
}

