/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.annotations;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.core.annotations.OSGiAnnotationProcessor;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;

public class CustomHeaderAnnotationProcessor
implements OSGiAnnotationProcessor {
    private final List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();

    @Override
    public void processAnnotation(Annotation annotation, String type) {
        if ("org.osgi.annotation.bundle.Headers".equals(type)) {
            OSGiAnnotationProcessor.expressions((Expression)annotation).filter(Annotation.class::isInstance).map(Annotation.class::cast).forEach(this::addHeaderValue);
        } else if ("org.osgi.annotation.bundle.Header".equals(type)) {
            this.addHeaderValue(annotation);
        }
    }

    private void addHeaderValue(Annotation annotation) {
        OSGiAnnotationProcessor.member((Expression)annotation, "name").flatMap(OSGiAnnotationProcessor::stringValue).flatMap(name -> OSGiAnnotationProcessor.member((Expression)annotation, "value").flatMap(OSGiAnnotationProcessor::stringValue).map(value -> new AbstractMap.SimpleEntry<String, String>((String)name, (String)value))).ifPresent(this.headers::add);
    }

    @Override
    public void apply(IBaseModel model) {
        if (model instanceof IBundlePluginModelBase) {
            IBundlePluginModelBase pluginModel = (IBundlePluginModelBase)model;
            IBundleModel bundleModel = pluginModel.getBundleModel();
            IBundle bundle = bundleModel.getBundle();
            for (Map.Entry<String, String> entry : this.headers) {
                bundle.setHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

