/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.menus.UIElement;
import org.osgi.service.event.EventHandler;

public class ToggleStatusBarHandler
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND_ID_TOGGLE_STATUSBAR = "org.eclipse.ui.window.togglestatusbar";
    private static final String BOTTOM_TRIM_ID = "org.eclipse.ui.trim.status";
    private final HashMap<IWorkbenchWindow, EventHandler> eventHandlers = new HashMap();
    private final HashMap<IWorkbenchWindow, IEventBroker> eventBrokers = new HashMap();

    public Object execute(ExecutionEvent event) {
        MUIElement trimStatus;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow(event);
        if (!(window instanceof WorkbenchWindow)) {
            return null;
        }
        if (!this.eventHandlers.containsKey(window)) {
            this.initializeEventHandler(window);
        }
        if ((trimStatus = ToggleStatusBarHandler.getTrimStatus((WorkbenchWindow)window)) != null) {
            trimStatus.setVisible(!trimStatus.isVisible());
        }
        return null;
    }

    private void initializeEventHandler(IWorkbenchWindow window) {
        IEventBroker eventBroker = (IEventBroker)window.getService(IEventBroker.class);
        this.eventBrokers.put(window, eventBroker);
        EventHandler eventHandler = event -> {
            Object element = event.getProperty("ChangedElement");
            if (element != null && element == ToggleStatusBarHandler.getTrimStatus((WorkbenchWindow)window)) {
                ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
                HashMap<String, WorkbenchWindow> filter = new HashMap<String, WorkbenchWindow>();
                filter.put("org.eclipse.ui.IWorkbenchWindow", (WorkbenchWindow)window);
                commandService.refreshElements(COMMAND_ID_TOGGLE_STATUSBAR, filter);
            }
        };
        this.eventHandlers.put(window, eventHandler);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", eventHandler);
    }

    public void dispose() {
        for (Map.Entry<IWorkbenchWindow, EventHandler> w : this.eventHandlers.entrySet()) {
            IEventBroker eventBroker = this.eventBrokers.get(w.getKey());
            EventHandler eventHandler = w.getValue();
            if (eventBroker == null || eventHandler == null) continue;
            eventBroker.unsubscribe(eventHandler);
        }
        super.dispose();
    }

    @Override
    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchLocationService wls = element.getServiceLocator().getService(IWorkbenchLocationService.class);
        IWorkbenchWindow window = wls.getWorkbenchWindow();
        if (!(window instanceof WorkbenchWindow)) {
            return;
        }
        MUIElement trimStatus = ToggleStatusBarHandler.getTrimStatus((WorkbenchWindow)window);
        if (trimStatus != null) {
            element.setText(trimStatus.isVisible() ? WorkbenchMessages.ToggleStatusBarVisibilityAction_hide_text : WorkbenchMessages.ToggleStatusBarVisibilityAction_show_text);
        }
    }

    private static MUIElement getTrimStatus(WorkbenchWindow window) {
        EModelService modelService = window.getService(EModelService.class);
        MWindow searchRoot = window.getModel();
        return modelService.find(BOTTOM_TRIM_ID, (MUIElement)searchRoot);
    }
}

