/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.examples;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.figures.GaugeFigure;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GaugeExample {
    private static int counter = 0;

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(300, 250);
        shell.setBackground(XYGraphMediaFactory.getInstance().getColor(255, 255, 255));
        shell.open();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        final GaugeFigure gaugeFigure = new GaugeFigure();
        gaugeFigure.setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(0, 0, 0));
        gaugeFigure.setForegroundColor(XYGraphMediaFactory.getInstance().getColor(255, 255, 255));
        gaugeFigure.setRange(-100.0, 100.0);
        gaugeFigure.setLoLevel(-50.0);
        gaugeFigure.setLoloLevel(-80.0);
        gaugeFigure.setHiLevel(60.0);
        gaugeFigure.setHihiLevel(80.0);
        gaugeFigure.setMajorTickMarkStepHint(50);
        lws.setContents((IFigure)gaugeFigure);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        gaugeFigure.setValue(Math.sin((double)counter++ / 10.0) * 100.0);
                    }
                });
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        future.cancel(true);
        scheduler.shutdown();
    }
}

