/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser.example;

import java.util.Locale;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.widgets.datechooser.DateChooser;
import org.eclipse.nebula.widgets.datechooser.DateChooserTheme;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DateChooserExampleTab
extends AbstractExampleTab {
    public static final String GRAY_THEME = "GRAY (default)";
    public static final String BLUE_THEME = "BLUE";
    public static final String YELLOW_THEME = "YELLOW";
    private DateChooser chooser = null;
    private Button borderStyle;
    private Button multiStyle;
    private Combo themes;
    private Locale locale;
    private Button gridVisible;
    private Button weeksVisible;
    private Button footerVisible;
    private Button navigationEnabled;
    private Button autoChangeOnAdjacent;
    private Button autoSelectOnFooter;
    private Listener recreateListener = new Listener(){

        public void handleEvent(Event event) {
            DateChooserExampleTab.this.recreateExample();
        }
    };

    private void applyTheme() {
        switch (this.themes.getSelectionIndex()) {
            case 0: {
                this.chooser.setTheme(DateChooserTheme.GRAY);
                break;
            }
            case 1: {
                this.chooser.setTheme(DateChooserTheme.BLUE);
                break;
            }
            case 2: {
                this.chooser.setTheme(DateChooserTheme.YELLOW);
            }
        }
    }

    private Button createCheckBox2(Composite parent, String text, boolean selected) {
        Button cb = new Button(parent, 32);
        cb.setText(text);
        cb.setSelection(selected);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        cb.setLayoutData((Object)data);
        return cb;
    }

    public Control createControl(Composite parent) {
        int style = 0;
        if (this.borderStyle.getSelection()) {
            style |= 0x800;
        }
        if (this.multiStyle.getSelection()) {
            style |= 2;
        }
        this.chooser = new DateChooser(parent, style);
        this.applyTheme();
        this.chooser.setGridVisible(this.gridVisible.getSelection());
        this.chooser.setWeeksVisible(this.weeksVisible.getSelection());
        this.chooser.setFooterVisible(this.footerVisible.getSelection());
        this.chooser.setNavigationEnabled(this.navigationEnabled.getSelection());
        this.chooser.setAutoChangeOnAdjacent(this.autoChangeOnAdjacent.getSelection());
        this.chooser.setAutoSelectOnFooter(this.autoSelectOnFooter.getSelection());
        return this.chooser;
    }

    public String[] createLinks() {
        return null;
    }

    private void createGUISettingsGroup(Composite parent) {
        Group gp = new Group(parent, 0);
        gp.setText("GUI Settings");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)gp);
        gp.setLayoutData((Object)new GridData(4, 4, false, false));
        new Label((Composite)gp, 0).setText("Themes:");
        this.themes = new Combo((Composite)gp, 2048);
        this.themes.setItems(new String[]{GRAY_THEME, BLUE_THEME, YELLOW_THEME});
        this.themes.select(0);
        this.themes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserExampleTab.this.applyTheme();
            }
        });
        new Label((Composite)gp, 0).setText("Locale:");
        final Combo localeCombo = new Combo((Composite)gp, 2048);
        final Locale[] locales = Locale.getAvailableLocales();
        Locale dl = Locale.getDefault();
        int i = 0;
        while (i < locales.length) {
            localeCombo.add(locales[i].getDisplayName());
            if (locales[i].equals(dl)) {
                localeCombo.select(i);
            }
            ++i;
        }
        localeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserExampleTab.this.locale = locales[localeCombo.getSelectionIndex()];
                DateChooserExampleTab.this.chooser.setLocale(DateChooserExampleTab.this.locale);
            }
        });
        this.gridVisible = this.createCheckBox2((Composite)gp, "GridVisible", true);
        this.gridVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserExampleTab.this.chooser.setGridVisible(DateChooserExampleTab.this.gridVisible.getSelection());
            }
        });
        this.weeksVisible = this.createCheckBox2((Composite)gp, "WeeksVisible", false);
        this.weeksVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserExampleTab.this.chooser.setWeeksVisible(DateChooserExampleTab.this.weeksVisible.getSelection());
                DateChooserExampleTab.this.chooser.getParent().layout();
            }
        });
        this.footerVisible = this.createCheckBox2((Composite)gp, "FooterVisible", false);
        this.footerVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserExampleTab.this.chooser.setFooterVisible(DateChooserExampleTab.this.footerVisible.getSelection());
                DateChooserExampleTab.this.chooser.getParent().layout();
            }
        });
        this.navigationEnabled = this.createCheckBox2((Composite)gp, "NavigationEnabled", true);
        this.navigationEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserExampleTab.this.chooser.setNavigationEnabled(DateChooserExampleTab.this.navigationEnabled.getSelection());
            }
        });
    }

    private void createStyleGroup(Composite parent) {
        Group gp = new Group(parent, 0);
        gp.setText("Style");
        gp.setLayout((Layout)new RowLayout());
        GridData data = new GridData(4, 4, false, false);
        data.horizontalSpan = 2;
        gp.setLayoutData((Object)data);
        this.borderStyle = new Button((Composite)gp, 32);
        this.borderStyle.setText("SWT.BORDER");
        this.borderStyle.addListener(13, this.recreateListener);
        this.multiStyle = new Button((Composite)gp, 32);
        this.multiStyle.setText("SWT.MULTI");
        this.multiStyle.addListener(13, this.recreateListener);
    }

    public void createParameters(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(parent);
        this.createStyleGroup(parent);
        this.createGUISettingsGroup(parent);
        this.createSelectionSettingsGroup(parent);
    }

    private void createSelectionSettingsGroup(Composite parent) {
        Group gp = new Group(parent, 0);
        gp.setText("Selection Settings");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)gp);
        gp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.autoChangeOnAdjacent = this.createCheckBox2((Composite)gp, "AutoChangeOnAdjacent", true);
        this.autoChangeOnAdjacent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserExampleTab.this.chooser.setAutoChangeOnAdjacent(DateChooserExampleTab.this.autoChangeOnAdjacent.getSelection());
            }
        });
        this.autoSelectOnFooter = this.createCheckBox2((Composite)gp, "AutoSelectOnFooter", false);
        this.autoSelectOnFooter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DateChooserExampleTab.this.chooser.setAutoSelectOnFooter(DateChooserExampleTab.this.autoSelectOnFooter.getSelection());
            }
        });
    }
}

