/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.jface;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.widgets.timeline.IColored;
import org.eclipse.nebula.widgets.timeline.ICursor;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class DefaultTimelineLabelProvider
extends LabelProvider
implements ITimelineLabelProvider,
IToolTipProvider,
IColorProvider {
    private final ResourceManager fResourceManager;

    public DefaultTimelineLabelProvider(ResourceManager resourceManager) {
        this.fResourceManager = resourceManager;
    }

    public String getToolTipText(Object element) {
        if (element instanceof ITimelineEvent) {
            return ((ITimelineEvent)element).getMessage();
        }
        return null;
    }

    @Override
    public Timing getTimings(Object element) {
        if (element instanceof ITimelineEvent) {
            return new Timing(((ITimelineEvent)element).getStartTimestamp(), ((ITimelineEvent)element).getDuration());
        }
        if (element instanceof ICursor) {
            return new Timing(((ICursor)element).getTimestamp());
        }
        return null;
    }

    public Color getForeground(Object element) {
        RGB rgb;
        if (element instanceof IColored && (rgb = ((IColored)element).getRgb()) != null) {
            return this.fResourceManager.createColor(rgb);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

