/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.refactoring;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.refactoring.IFileVisitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;

public abstract class SourceFileFinder
implements IResourceVisitor {
    private final TextFileDocumentProvider fProvider;
    protected final ISourceProject fProject;
    protected final IFileVisitor fVisitor;
    protected final Language fLanguage;
    private final Set<String> fFileNameExtensions = new HashSet<String>();

    public SourceFileFinder(TextFileDocumentProvider provider, ISourceProject project, IFileVisitor visitor, Language language) {
        this.fProvider = provider;
        this.fProject = project;
        this.fVisitor = visitor;
        Language lang = this.fLanguage = language;
        while (lang != null) {
            for (String ext : lang.getFilenameExtensions()) {
                this.fFileNameExtensions.add(ext);
            }
            lang = lang.getBaseLanguage();
        }
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            if (this.fFileNameExtensions.contains(file.getFileExtension())) {
                this.visitFile(file);
            }
            return false;
        }
        return true;
    }

    private void visitFile(IFile file) {
        System.out.println("Visiting file " + file.getName() + ".");
        IParseController parseCtrlr = ServiceFactory.getInstance().getParseController(this.fLanguage);
        IPath declFilePath = file.getLocation().removeFirstSegments(this.fProject.getRawProject().getLocation().segmentCount());
        FileEditorInput fileInput = new FileEditorInput(file);
        parseCtrlr.initialize(declFilePath, this.fProject, null);
        try {
            this.fProvider.connect((Object)fileInput);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        IDocument document = this.fProvider.getDocument((Object)fileInput);
        Object astRoot = parseCtrlr.parse(document.get(), (IProgressMonitor)new NullProgressMonitor());
        this.fVisitor.enterFile(file);
        this.doVisit(file, document, astRoot);
        this.fVisitor.leaveFile(file);
    }

    public abstract void doVisit(IFile var1, IDocument var2, Object var3);
}

