/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvttemplate.utilities;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseToStringVisitor;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.QVTtemplatePackage;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.util.QVTtemplateVisitor;

public class QVTtemplateToStringVisitor
extends QVTbaseToStringVisitor
implements QVTtemplateVisitor<String> {
    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ToStringVisitor.Factory FACTORY = new QVTtemplateToStringFactory();

    public QVTtemplateToStringVisitor(@NonNull StringBuilder s) {
        super(s);
    }

    @Override
    public String visitCollectionTemplateExp(@NonNull CollectionTemplateExp object) {
        this.safeVisit((Visitable)object.getBindsTo());
        this.append("{");
        boolean isFirst = true;
        for (OCLExpression part : object.getMember()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit((Visitable)part);
            isFirst = false;
        }
        Variable rest = object.getRest();
        if (rest != null) {
            this.append(" ++ ");
            this.appendName((Nameable)rest);
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitObjectTemplateExp(@NonNull ObjectTemplateExp object) {
        this.safeVisit((Visitable)object.getBindsTo());
        this.append("{");
        boolean isFirst = true;
        EList<PropertyTemplateItem> parts = object.getPart();
        if (parts != null) {
            for (PropertyTemplateItem part : parts) {
                if (!isFirst) {
                    this.append(", ");
                }
                this.safeVisit((Visitable)part);
                isFirst = false;
            }
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitPropertyTemplateItem(@NonNull PropertyTemplateItem object) {
        this.appendName((Nameable)object.getReferredProperty());
        this.append(" = ");
        this.safeVisit((Visitable)object.getValue());
        return null;
    }

    @Override
    public String visitTemplateExp(@NonNull TemplateExp object) {
        return this.visiting((Visitable)object);
    }

    protected static class QVTtemplateToStringFactory
    implements ToStringVisitor.Factory {
        protected QVTtemplateToStringFactory() {
            ToStringVisitor.addFactory((ToStringVisitor.Factory)this);
            QVTbaseToStringVisitor.FACTORY.getClass();
        }

        public @NonNull ToStringVisitor createToStringVisitor(@NonNull StringBuilder s) {
            return new QVTtemplateToStringVisitor(s);
        }

        public @NonNull EPackage getEPackage() {
            QVTtemplatePackage eInstance = QVTtemplatePackage.eINSTANCE;
            assert (eInstance != null);
            return eInstance;
        }
    }
}

