/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.junit.utils.rules;

import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RuleUtil {
    private RuleUtil() {
    }

    public static void runWith(Runnable run, TestRule rule) throws Exception {
        RuleUtil.callWith(RuleUtil.call(run), rule);
    }

    public static void safeRunWith(Runnable run, TestRule rule) throws Exception {
        RuleUtil.safeCallWith(RuleUtil.call(run), rule);
    }

    static Callable<?> call(final Runnable run) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                run.run();
                return null;
            }
        };
    }

    public static <V> V callWith(Callable<V> callable, TestRule rule) throws Exception {
        try {
            class CallableStatement
            extends Statement {
                final Callable<V> callable;
                V result;

                CallableStatement(Callable<V> callable) {
                    this.callable = callable;
                }

                public void evaluate() throws Throwable {
                    this.result = this.callable.call();
                }
            }
            CallableStatement statement = new CallableStatement(callable);
            rule.apply((Statement)statement, Description.EMPTY).evaluate();
            return statement.result;
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    public static <V> V safeCallWith(Callable<V> callable, TestRule rule) {
        try {
            return RuleUtil.callWith(callable, rule);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to invoke callable with rule: " + e.getLocalizedMessage()));
            return null;
        }
    }
}

