/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.plugin.builder;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.toolsmiths.plugin.builder.AbstractPapyrusBuilder;
import org.eclipse.papyrus.toolsmiths.plugin.builder.Activator;
import org.eclipse.papyrus.toolsmiths.plugin.builder.PapyrusBuilderKind;

public interface IPapyrusBuilderProvider {
    public String getProblemMarkerType(PapyrusBuilderKind var1);

    public boolean providesBuilder(PapyrusBuilderKind var1, URI var2);

    default public boolean providesBuilder(PapyrusBuilderKind builderKind, IResource resource) {
        boolean result = false;
        if (resource.getType() == 1) {
            URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toPortableString(), (boolean)true);
            result = this.providesBuilder(builderKind, uri);
        }
        return result;
    }

    public AbstractPapyrusBuilder getBuilder(PapyrusBuilderKind var1, IProject var2);

    default public boolean hasContentType(URI resourceURI, String contentType) {
        boolean result = false;
        try {
            IContentType match = Platform.getContentTypeManager().getContentType(contentType);
            Map description = URIConverter.INSTANCE.contentDescription(resourceURI, Map.of("REQUESTED_PROPERTIES", Set.of("org.eclipse.emf.ecore:contentType")));
            result = Optional.ofNullable((String)description.get("org.eclipse.emf.ecore:contentType")).map(arg_0 -> ((IContentTypeManager)Platform.getContentTypeManager()).getContentType(arg_0)).filter(type -> match != null && type.isKindOf(match)).isPresent();
        }
        catch (IOException e) {
            Activator.log.error("Failed to determine content type of model resource.", (Throwable)e);
        }
        return result;
    }
}

