/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.profilemigration.internal.migrators.atomic.stereotype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.toolsmiths.profilemigration.MigratorProfileApplication;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationDescriptor;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.data.structure.StereotypeApplicationRegistry;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.ProfileUtil;
import org.eclipse.papyrus.toolsmiths.profilemigration.internal.utils.TreeNodeUtils;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.AbstractMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.migrators.atomic.stereotype.IChangeIsAbstractFromStereotypeMigrator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.Activator;
import org.eclipse.papyrus.toolsmiths.profilemigration.ui.dialogs.ChangeIsAbstractFromStereotypeDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class ChangeIsAbstractFromStereotypeMigrator
extends AbstractMigrator
implements IChangeIsAbstractFromStereotypeMigrator {
    private Stereotype stereotype;
    private boolean isAbstract;

    public ChangeIsAbstractFromStereotypeMigrator(TreeNode treeNode) {
        super(treeNode);
    }

    public static boolean isValid(TreeNode treeNode) {
        if (TreeNodeUtils.isChangeType(treeNode, MigratorProfileApplication.appliedProfile)) {
            EObject element = TreeNodeUtils.getChangedElement(treeNode);
            EStructuralFeature structuralFeature = TreeNodeUtils.getChangedAttribute(treeNode);
            if (element instanceof Stereotype && structuralFeature == UMLPackage.eINSTANCE.getClassifier_IsAbstract()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return ChangeIsAbstractFromStereotypeMigrator.isValid(this.treeNode);
    }

    @Override
    public void migrationAction() {
        if (this.isAbstract) {
            List<Stereotype> subStereotypes = ProfileUtil.findAllSubStereotypes(this.stereotype, MigratorProfileApplication.profiledModel, true);
            List<StereotypeApplicationDescriptor> list = StereotypeApplicationRegistry.getStereotypeApplicationDescriptors(this.stereotype);
            if (!list.isEmpty()) {
                if (this.isDisplayDialogPreference()) {
                    HashMap mapElementToStereotype = new HashMap();
                    for (StereotypeApplicationDescriptor descriptor : list) {
                        if (mapElementToStereotype.get(descriptor.getOwner()) == null) {
                            ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
                            stereotypes.add(descriptor.getStereotype());
                            mapElementToStereotype.put(descriptor.getOwner(), stereotypes);
                            continue;
                        }
                        ((List)mapElementToStereotype.get(descriptor.getOwner())).add(descriptor.getStereotype());
                    }
                    ChangeIsAbstractFromStereotypeDialog dialog = new ChangeIsAbstractFromStereotypeDialog(Display.getDefault().getActiveShell(), this.stereotype, subStereotypes, mapElementToStereotype);
                    dialog.open();
                    for (Map.Entry entry : dialog.getResult().entrySet()) {
                        Element element = (Element)entry.getKey();
                        List newStereotypeList = (List)entry.getValue();
                        StereotypeApplicationDescriptor stereotypeApplicationDescriptor = StereotypeApplicationRegistry.getStereotypeApplicationDescriptors(element, this.stereotype);
                        if (stereotypeApplicationDescriptor == null) continue;
                        for (Stereotype newStereotype : newStereotypeList) {
                            if (!stereotypeApplicationDescriptor.getOwner().isStereotypeApplicable(newStereotype)) continue;
                            EObject stereotypeApplication = stereotypeApplicationDescriptor.getOwner().applyStereotype(newStereotype);
                            MigratorProfileApplication.newStereotypeApplication.add(stereotypeApplication);
                            StereotypeApplicationDescriptor descriptor = new StereotypeApplicationDescriptor(newStereotype, element);
                            StereotypeApplicationRegistry.stereotypeApplicationList.add(descriptor);
                            for (Map.Entry<Property, Object> values : stereotypeApplicationDescriptor.getMapPropertyToApplicationValue().entrySet()) {
                                stereotypeApplicationDescriptor.getOwner().setValue(newStereotype, values.getKey().getName(), values.getValue());
                                for (Property attribute : newStereotype.getAttributes()) {
                                    Object value = descriptor.getOwner().getValue(newStereotype, attribute.getName());
                                    descriptor.getMapPropertyToApplicationValue().put(attribute, value);
                                }
                            }
                        }
                    }
                }
                StereotypeApplicationRegistry.stereotypeApplicationList.removeAll(list);
            }
        }
    }

    @Override
    public void initAttributes() {
        if (this.isValid()) {
            EObject element = TreeNodeUtils.getChangedElement(this.treeNode);
            this.stereotype = (Stereotype)element;
            this.isAbstract = this.stereotype.isAbstract();
        }
    }

    @Override
    public int getPriority() {
        return 100;
    }

    private boolean isDisplayDialogPreference() {
        IPreferenceStore prefStore = Activator.getDefault().getPreferenceStore();
        return prefStore.getBoolean("SuperStereotypeBecomingAbstract");
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public boolean getValue() {
        return this.isAbstract;
    }

    @Override
    public Element getChangedElement() {
        return this.getStereotype();
    }

    @Override
    public Object getNewValue() {
        return this.getValue();
    }

    @Override
    public EStructuralFeature getChangedStructuralFeature() {
        return UMLPackage.eINSTANCE.getClassifier_IsAbstract();
    }
}

