/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.ExternalizeProfileApplicationsPage;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertyShowInContext;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;

public class ExternalizeProfileApplicationsWizard
extends Wizard
implements IWorkbenchWizard {
    static final String PROPERTY_SHEET_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    private IWorkbenchWindow workbenchWindow;
    private Package package_;
    private ExternalizeProfileApplicationsPage mainPage;
    private List<ProfileApplication> initialSelections;

    public ExternalizeProfileApplicationsWizard() {
        this.setWindowTitle(Messages.ExternalizeProfileApplicationsWizard_0);
        this.setDialogSettings(DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getSimpleName()));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbenchWindow = workbench.getActiveWorkbenchWindow();
        EObject eObject = EMFHelper.getEObject((Object)selection.getFirstElement());
        if (eObject instanceof Package) {
            this.init((Package)eObject, Collections.emptyList());
        }
    }

    public void init(Package package_, Iterable<ProfileApplication> initialSelections) {
        this.package_ = package_;
        this.initialSelections = ImmutableList.copyOf(initialSelections);
        if (this.mainPage != null) {
            this.mainPage.setInput(package_);
            this.mainPage.select(initialSelections);
        }
        if (this.workbenchWindow == null) {
            this.workbenchWindow = Activator.getActiveWorkbenchWindow();
        }
    }

    public void addPages() {
        this.mainPage = new ExternalizeProfileApplicationsPage();
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.setInput(this.package_);
        this.mainPage.select(this.initialSelections);
    }

    public boolean performFinish() {
        boolean result = false;
        this.mainPage.saveSettings();
        List profileApplications = this.mainPage.getSelectedProfileApplications();
        URI resourceURI = this.mainPage.getResourceURI();
        String modelName = this.mainPage.getModelName();
        if (!profileApplications.isEmpty() && resourceURI != null) {
            Command command = DecoratorModelUtils.createSeparateProfileApplicationsCommand((Iterable)profileApplications, (URI)resourceURI, (String)modelName);
            TransactionUtil.getEditingDomain((EObject)this.package_).getCommandStack().execute(command);
            result = true;
            this.refreshPropertySheet();
        }
        return result;
    }

    private void refreshPropertySheet() {
        PropertyShowInContext context;
        PropertySheet propertiesView;
        if (this.workbenchWindow != null && (propertiesView = (PropertySheet)this.workbenchWindow.getActivePage().findView(PROPERTY_SHEET_VIEW_ID)) != null && (context = (PropertyShowInContext)propertiesView.getShowInContext()) != null && context.getSelection() instanceof IStructuredSelection && propertiesView.getCurrentPage() instanceof ISelectionListener) {
            ISelectionListener page = (ISelectionListener)propertiesView.getCurrentPage();
            IStructuredSelection selection = (IStructuredSelection)context.getSelection();
            page.selectionChanged(context.getPart(), (ISelection)StructuredSelection.EMPTY);
            page.selectionChanged(context.getPart(), (ISelection)new StructuredSelection(selection.toArray()));
        }
    }
}

