/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.example.core.sashwindows.fulleditor.editor;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrus.example.core.sashwindows.fulleditor.Activator;
import org.eclipse.papyrus.example.core.sashwindows.fulleditor.texteditor.TextEditorPartModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelMngr;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.IPageModelFactory;
import org.eclipse.papyrus.infra.core.sasheditor.editor.AbstractMultiPageSashEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class DiMultiTextEditor
extends AbstractMultiPageSashEditor {
    protected DiSashModelMngr sashModelMngr;
    protected ResourceMngr resourceMngr;
    IContentChangedListener contentChangedListener = new IContentChangedListener(){

        public void contentChanged(IContentChangedListener.ContentEvent event) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.papyrus.example.core.sashwindows.fulleditor", "contentChanged()"));
            DiMultiTextEditor.this.markDirty();
            DiMultiTextEditor.this.refreshTabs();
        }
    };
    protected boolean isDirty = false;
    private IPropertyListener dirtyPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 257) {
                DiMultiTextEditor.this.isDirty = true;
            }
        }
    };

    public DiMultiTextEditor() {
        this.addPropertyListener(this.dirtyPropertyListener);
    }

    protected void markDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }

    protected ISashWindowsContentProvider createPageProvider() {
        SimplePageModelFactory pageFactory = new SimplePageModelFactory();
        this.sashModelMngr = new DiSashModelMngr((IPageModelFactory)pageFactory);
        ISashWindowsContentProvider pageProvider = this.sashModelMngr.getISashWindowsContentProvider();
        pageProvider.addPage((Object)new TextEditorPartModel());
        this.sashModelMngr.getSashModelContentChangedProvider().addListener(this.contentChangedListener);
        return pageProvider;
    }

    public void dispose() {
        this.sashModelMngr.getSashModelContentChangedProvider().removeListener(this.contentChangedListener);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            editor.doSave(monitor);
            this.isDirty = false;
        }
    }

    public void doSaveAs() {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null) {
            editor.doSaveAs();
            this.setInput(editor.getEditorInput());
            this.isDirty = false;
        }
    }

    public void gotoMarker(IMarker marker) {
        IDE.gotoMarker((IEditorPart)this.getActiveEditor(), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public class ResourceMngr {
        private static final String DI_FILE_EXTENSION = "di";
        private ResourceSet resourceSet;
        private Resource diResource;

        public ResourceMngr() {
            this.createResourceSet();
        }

        public Resource getDiResource() {
            return this.diResource;
        }

        protected void createResourceSet() {
            if (this.resourceSet != null) {
                return;
            }
            this.resourceSet = new ResourceSetImpl();
            this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        }

        public void loadResource(IFile file) {
            IPath fullPath = file.getFullPath().removeFileExtension();
            IPath filePath = fullPath.addFileExtension(DI_FILE_EXTENSION);
            URI uri = URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true);
            try {
                this.diResource = this.resourceSet.getResource(uri, true);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.example.core.sashwindows.fulleditor", e.getMessage()));
            }
        }

        public void createResource(IFile file) {
            IPath fullPath = file.getFullPath().removeFileExtension();
            IPath filePath = fullPath.addFileExtension(DI_FILE_EXTENSION);
            URI uri = URI.createPlatformResourceURI((String)filePath.toString(), (boolean)true);
            this.diResource = this.resourceSet.createResource(uri);
        }

        public void saveResource() throws IOException {
            this.diResource.save(null);
        }

        public void saveResource(IProgressMonitor monitor) throws IOException {
            monitor.beginTask("Saving resources", 3);
            monitor.worked(1);
            this.saveResource();
            monitor.worked(1);
            monitor.done();
        }
    }

    public class SimplePageModelFactory
    implements IPageModelFactory {
        public IPageModel createIPageModel(Object pageIdentifier) {
            return (IPageModel)pageIdentifier;
        }
    }
}

