/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.registries;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsPackage;
import org.eclipse.papyrus.infra.types.core.Activator;
import org.eclipse.papyrus.infra.types.core.factories.IElementTypeConfigurationFactory;
import org.eclipse.papyrus.infra.types.core.factories.impl.MetamodelTypeFactory;
import org.eclipse.papyrus.infra.types.core.factories.impl.SpecializationTypeFactory;

public class ElementTypeConfigurationTypeRegistry {
    private static volatile ElementTypeConfigurationTypeRegistry registry;
    protected Map<String, IElementTypeConfigurationFactory<? extends ElementTypeConfiguration>> elementTypeConfigurationTypeToFactory = null;

    private ElementTypeConfigurationTypeRegistry() {
    }

    public static synchronized ElementTypeConfigurationTypeRegistry getInstance() {
        if (registry == null) {
            registry = new ElementTypeConfigurationTypeRegistry();
            registry.init();
        }
        return registry;
    }

    protected void init() {
        IConfigurationElement[] elements;
        this.elementTypeConfigurationTypeToFactory = new HashMap<String, IElementTypeConfigurationFactory<? extends ElementTypeConfiguration>>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.types.core.elementTypeConfigurationKind");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String configurationClass = configurationElement.getAttribute("configurationClass");
            try {
                Object factoryClass = configurationElement.createExecutableExtension("factoryClass");
                if (factoryClass instanceof IElementTypeConfigurationFactory) {
                    this.elementTypeConfigurationTypeToFactory.put(configurationClass, (IElementTypeConfigurationFactory)factoryClass);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
        this.elementTypeConfigurationTypeToFactory.put(ElementTypesConfigurationsPackage.eINSTANCE.getMetamodelTypeConfiguration().getInstanceTypeName(), new MetamodelTypeFactory());
        this.elementTypeConfigurationTypeToFactory.put(ElementTypesConfigurationsPackage.eINSTANCE.getSpecializationTypeConfiguration().getInstanceTypeName(), new SpecializationTypeFactory());
    }

    protected <T extends ElementTypeConfiguration> IElementTypeConfigurationFactory<T> getFactory(ElementTypeConfiguration elementTypeConfiguration) {
        String elementTypeConfigurationType = elementTypeConfiguration.eClass().getInstanceTypeName();
        IElementTypeConfigurationFactory<? extends ElementTypeConfiguration> factory = this.elementTypeConfigurationTypeToFactory.get(elementTypeConfigurationType);
        return factory;
    }

    public <T extends ElementTypeConfiguration> IElementType getElementType(T elementTypeConfiguration) {
        if (elementTypeConfiguration == null) {
            return null;
        }
        IElementTypeConfigurationFactory<T> factory = this.getFactory(elementTypeConfiguration);
        if (factory != null) {
            IHintedType elementType = factory.createElementType(elementTypeConfiguration);
            return elementType;
        }
        return null;
    }
}

